//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// main.c -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:25:22 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Apr 21 06:54:06 1999
// Update Count     : 87
// 

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "key.h"
#include "hash.h"
#include "symbol.h"
#include "include.h"
#include "token.h"
#include "table.h"
#include "input.h"
#include "output.h"
#include "parse.h"

FILE *yyin = stdin;
FILE *yyout = stdout;

bool er = false;
bool Yield = false;
bool verify = false;
bool trace = false;
bool gnu = false;
bool user = false;
bool profile = false;

int main( int argc, char *argv[] ) {
    int i, j;
    char *infile = NULL;
    char *outfile = NULL;

    //
    // The translator can receive 2 types of arguments.
    //
    // The first type begin with a '-' character and are generally -D<string>
    // type arguments.  We are interested in arguments, -D__U_YIELD__,
    // -D__U_VERIFY__, -D__U_TRACE__, -D__U_EXCEPTION__ and __GNUG__ because
    // they affect the code that is produced by the translator.
    //
    // The second type of argument are input and output file specifications.
    // These arguments do not begin with a '-' character.
    // The first file specification is taken to be the input file specification
    // while the second file specification is taken to be the output file
    // specification.  If no files are specified, stdin and stdout are assumed.
    // If more files are specified, an error results.
    //

    for ( i = 1; i < argc; i += 1 ) {
	if ( argv[i][0] == '-' ) {
	    if ( strcmp( argv[i], "-D__U_YIELD__" ) == 0 ) {
		Yield = true;
	    } else if ( strcmp( argv[i], "-D__U_VERIFY__" ) == 0 ) {
		verify = true;
	    } else if ( strcmp( argv[i], "-D__U_TRACE__" ) == 0 ) {
		trace = true;
	    } else if ( strcmp( argv[i], "-D__U_PROFILE__" ) == 0 ) {
		profile = true;
	    } else if ( strncmp( argv[i], "-D__GNUG__", strlen( "-D__GNUG__" ) ) == 0 ) {
		gnu = true;
	    } // if
	} else {
	    if ( infile == NULL ) {
		infile = argv[i];
		if ( ( yyin = fopen( infile, "r" ) ) == 0 ) {
		    fprintf( stderr, "%s: could not open file %s for reading.\n", argv[0], infile );
		    exit( -1 );
		} // if
	    } else if ( outfile == NULL ) {
		outfile = argv[i];
		if ( ( yyout = fopen( outfile, "w" ) ) == 0 ) {
		    fprintf( stderr, "%s: could not open file %s for writing.\n", argv[0], outfile );
		    exit( -1 );
		} // if
	    } else {
		for ( j = 0; j < argc; j += 1 ) {
		    fprintf( stderr, "%s ", argv[j] );
		} // for
		fprintf( stderr, "\n%s: usage: %s [input-file [output-file]] [options]\n", argv[0], argv[0] );
		exit( -1 );
	    } // if
	} // if
    } // for

    // This is the heart of the translator.  Although inefficient, it is very
    // simple.  First, we read in all the input and convert it to a list of
    // tokens.  Second, we parse this list extracting and inserting tokens as
    // necessary.  Third, we convert this list of tokens into an output stream
    // again.

    hash_table = new hash_table_t;

    keywords = new table_t( NULL );
    root = new table_t( NULL );

    global = root;					// pointer to global table
    top = root;						// pointer to current top table
    focus = root;					// pointer to current scope table

    // Insert the keywords into the root symbol table.
    
    for ( i = 0; key[i].text != NULL; i += 1 ) {
	hash_table->look( key[i].text, key[i].value );
    } // for

    read_all_input();
    parse( argv[0] );
    write_all_output();

#if 0
    global->display_table( 0 );
#endif


// TEMPORARY: deleting this data structure does not work!!!!!!!!!
//    delete root;
    delete keywords;

    delete hash_table;

    // close any open files before quitting.

    if ( yyin != stdin ) {
	fclose( yyin );
	if ( yyout != stdout ) {
	    fclose( yyout );
	} // if
    } // if

    // If an error has occurred during the translation phase, return a negative
    // result to signify this fact.  This will cause the host compiler to
    // terminate the compilation at this point, just as if the regular cpp had
    // failed.
    
// TEMPORARY
//    if ( er ) {
//	return -1;
//    } else {
	return 0;
//    } // if
} // main

// Local Variables: //
// compile-command: "dmake" //
// End: //
