//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// hash.c -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:04:17 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jan 20 16:03:38 1997
// Update Count     : 47
// 

#include <stdlib.h>
#include <stdio.h>

#include "hash.h"

#define HASH_MAGIC_VALUE 1048583 // should be a prime number

hash_t::hash_t( const char *t, hash_t *l, int v ) {
    text = new char[strlen( t ) + 1];
    strcpy( text, t );
    link = l;
    value = v;
    InSymbolTable = 0;
} // hash_t::hash_t

hash_t::~hash_t() {
    delete text;
} // hash_t::~hash_t

hash_table_t::hash_table_t() {
     for ( int i = 0; i < HASH_TABLE_SIZE; i += 1 ) {
	 table[i] = NULL;
     } // for
 } // hash_table_t::hash_table_t

hash_table_t::~hash_table_t() {
    for ( int i = 0; i < HASH_TABLE_SIZE; i += 1 ) {
	hash_t *hash = table[i];
	while ( hash != NULL ) {
	    hash_t *temp = hash;
	    hash = hash->link;
	    delete temp;
	} // while
    } // for
} // hash_table_t::~hash_table_t

hash_t *hash_table_t::look( const char *text, int value ) {

    unsigned int key;
    const char *cp;

    for ( key = 0, cp = text; *cp != '\0'; cp += 1 ) {
	key += (int) *cp;
    } // for
    key *= HASH_MAGIC_VALUE;
    key = key % HASH_TABLE_SIZE;
    hash_t *hash = table[ key ];

    // if we can find a matching entry in the hash table,
    // return a pointer to that entry
    
    while ( hash != NULL ) {
	if ( strcmp( hash->text, text ) == 0 ) {
	    return hash;
	} // if
	hash = hash->link;
    } // while

    // if we could not find a matching entry, create a new
    // hash table entry, and insert it into the hash table
    
    hash = new hash_t( text, table[key], value );
    table[key] = hash;

    return hash;

} // hash_table::look

// declare an instance of a hash table

hash_table_t *hash_table;

// Local Variables: //
// compile-command: "dmake" //
// End: //
