//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// gen.h -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:36:43 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Feb 10 10:59:43 1999
// Update Count     : 47
// 


#ifndef __GEN_H__
#define __GEN_H__


class token_t;
class symbol_t;
class hash_t;

void gen_code( token_t * before, const char * string );
void gen_error( token_t * before, const char * string );
void gen_warning( token_t * before, const char * string );

void gen_wait_prefix( token_t * before, token_t * after );
void gen_with( token_t * before, token_t * after );
void gen_wait_suffix( token_t * before );
void gen_signal_prefix( token_t * before );
void gen_signal_suffix( token_t * before );
void gen_signalblock_prefix( token_t * before );
void gen_signalblock_suffix( token_t * before );
void gen_suspend_prefix( token_t * before, symbol_t *symbol );
void gen_suspend_suffix( token_t * before, symbol_t *symbol );
void gen_resume_prefix( token_t * before, symbol_t *symbol );
void gen_resume_suffix( token_t * before, symbol_t *symbol );
void gen_class_base( token_t * before, symbol_t * symbol );
void gen_member_prefix( token_t * before, symbol_t * symbol );
void gen_member_suffix( token_t * before, symbol_t * symbol );
void gen_main_prefix( token_t * before, symbol_t * symbol );
void gen_main_suffix( token_t * before, symbol_t * symbol );
void gen_initializer( token_t * before, symbol_t * symbol, char * prefix );
void gen_serial_initializer( token_t * before, symbol_t * symbol );
void gen_constructor_parameter( token_t * before, symbol_t * symbol, bool defarg );
void gen_constructor_prefix( token_t * before, symbol_t * symbol );
void gen_constructor_suffix( token_t * before, symbol_t * symbol );
void gen_constructor( token_t * before, symbol_t * symbol );
void gen_destructor_prefix( token_t * before, symbol_t * symbol );
void gen_destructor_suffix( token_t * before, symbol_t * symbol );
void gen_destructor( token_t * before, symbol_t * symbol );
void gen_class_prefix( token_t * before, symbol_t * symbol );
void gen_class_suffix( token_t * before, symbol_t * symbol );
void gen_access( token_t * before, int access );
void gen_mutex( token_t * before, symbol_t * symbol );
void gen_destruct( token_t * before, symbol_t * symbol );
void gen_mutex_entry( token_t * before, symbol_t * symbol );
void gen_full_name( token_t * before, symbol_t * symbol );
void gen_event_kind( token_t * before, symbol_t * symbol );
void gen_verify( token_t * before );
void gen_yield( token_t * before );
void gen_entry( token_t * before, unsigned int );
void gen_mask( token_t * before, unsigned int );
void gen_hash( token_t * before, hash_t * hash );
void gen_class( token_t * before );

void gen_uthrow_prefix( token_t * before, token_t * after );
void gen_uthrow_uat_prefix( token_t * before, token_t * after );
void gen_uthrow_suffix( token_t * before );
void gen_raise_prefix( token_t * before, token_t * after );
void gen_raise_uat_prefix( token_t * before, token_t * after );
void gen_raise_suffix( token_t * before );

#endif __GEN_H__

// Local Variables: //
// compile-command: "dmake" //
// End: //
