//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// gen.c -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:00:53 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May  3 16:31:40 1999
// Update Count     : 578
// 


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "assert.h"
#include "main.h"
#include "name.h"
#include "key.h"
#include "hash.h"
#include "attribute.h"
#include "symbol.h"
#include "structor.h"
#include "include.h"
#include "token.h"
#include "table.h"
#include "input.h"
#include "gen.h"


void gen_code( token_t * before, const char * text ) {
    token_t *temp;
    temp = new token_t( CODE, hash_table->look( text ) );
    temp->add_token_before( *before );
} // gen_code


void gen_quote_code( token_t * before, const char * text ) {
    assert( text != NULL );
    char copy[strlen( text ) + 2 + 1];
    strcpy( copy, "\"" ); strcat( copy, text ); strcat( copy, "\"" );
    gen_code( before, copy );
} // gen_code


void gen_error( token_t * before, const char * text ) {
    token_t *temp;
    temp = new token_t( ERROR, hash_table->look( text ) );
    temp->add_token_before( *before );
    er = true;
} // gen_error


void gen_warning( token_t * before, const char * text ) {
    token_t *temp;
    temp = new token_t( WARNING, hash_table->look( text ) );
    temp->add_token_before( *before );
} // gen_warning


void gen_class( token_t * before ) {
    gen_code( before, "class" );
} // gen_class


void gen_class_base( token_t * before, symbol_t * symbol ) {
    assert( symbol != NULL );

    if ( symbol->key == COROUTINE || symbol->key == TASK ||
	 symbol->key == DUALEVENT || symbol->key == RAISEEVENT || symbol->key == THROWEVENT ) {
	assert( before != NULL );

	token_t * next;

	// check if there is already a base specifier for this type

	if ( before->value == ':' ) {
	    // advance to the next token so that the implicit base specifier
	    // appears at the start of the base specifier list

	    next = before->next_parse_token();
	    assert( next != NULL );
	} else {
	    next = before;
	    gen_code( next, ":" );
	} // if

	if ( symbol->key == COROUTINE ) {
	    gen_code( next, "public uBaseCoroutine" );
	} else if ( symbol->key == TASK ) {
	    if ( symbol->attribute.value2 & PERIODIC_ATTRIBUTE ) {
		gen_code( next, "public uPeriodicBaseTask" );
	    } else if ( symbol->attribute.value2 & APERIODIC_ATTRIBUTE ) {
		gen_code( next, "public uRealTimeBaseTask" );
	    } else if ( symbol->attribute.value2 & SPORADIC_ATTRIBUTE ) {
		gen_code( next, "public uSporadicBaseTask" );
	    } else {
		gen_code( next, "public uBaseTask" );
	    } // if
	} else if ( symbol->key == DUALEVENT ) {
	    gen_code( next, "public uAEHM :: uDualClass" );
	} else if ( symbol->key == RAISEEVENT ) {
	    gen_code( next, "public uAEHM :: uRaiseClass" );
	} else if ( symbol->key == THROWEVENT ) {
	    gen_code( next, "public uAEHM :: uThrowClass" );
	} // if

	// insert a comma if the base specifier list is already started

	if ( before->value == ':' ) {
	    gen_code( next, "," );
	} // if
    } // if
} // gen_class_base


void gen_mask( token_t * before, unsigned int index ) {
    if ( index >= MAXENTRYBITS ) {
	char msg[128];

	sprintf( msg, "more than %d mutex methods", MAXENTRYBITS );
	gen_error( ahead, msg );
	index = MAXENTRYBITS - 1;
    } // if

    char itoc[20];
    sprintf( itoc, "0x%02x", index );
    gen_code( before, itoc );
} // gen_mask


void gen_entry( token_t * before, unsigned int index ) {
    if ( index >= MAXENTRYBITS ) {
	char msg[128];

	sprintf( msg, "more than %d mutex methods", MAXENTRYBITS );
	gen_error( ahead, msg );
	index = MAXENTRYBITS - 1;
    } // if
    
    char itoc[20];
    sprintf( itoc, "uMutex%02x", index );
    gen_code( before, itoc );
} // gen_entry


void gen_hash( token_t * before, hash_t * hash ) {
    assert( hash != NULL );
    gen_code( before, hash->text );
} // gen_hash


void gen_quote_hash( token_t * before, hash_t * hash ) {
    assert( hash != NULL );
    gen_quote_code( before, hash->text );
} // gen_hash


void gen_member_prefix( token_t * before, symbol_t * symbol ) {
    gen_code( before, "{" );
    if ( trace ) {
	gen_code( before, "uTracePetition uTracePetitionInstance ;" );
    } // if
    gen_code( before, "uSerialMember uSerialMemberInstance ( uSerialInstance ," );
    assert( symbol != NULL );
    gen_entry( before, symbol->index );
    gen_code( before, "," );
    gen_mask( before, symbol->index );
    gen_code( before, ") ;" );
    if ( trace && symbol->found->symbol->key != COROUTINE ) {
	gen_code( before, "uTraceEntry uTraceEntryInstance ( uTraceInstance ," );
 	gen_quote_hash( before, symbol->hash );
 	gen_code( before, ") ;" );
    } // if
} // gen_member_prefix


void gen_member_suffix( token_t * before, symbol_t * symbol ) {
    gen_code( before, "}" );
} // gen_member_suffix


void gen_main_prefix( token_t * before, symbol_t * symbol ) {
    table_t * table;
    assert( symbol != NULL );
    table = symbol->found;
    assert( table != NULL );
    assert( table->symbol != NULL );
    if ( table->symbol->key == COROUTINE ) {
	gen_code( before, "{ uCoroutineMain uCoroutineMainInstance ( * this ) ;" );
    } else if ( table->symbol->key == TASK ) {
	gen_code( before, "{" );
	gen_code( before, "uTaskMain uTaskMainInstance ( uSerialInstance ) ;" );
    } // if

    if ( trace ) {
	gen_code( before, "uTraceMain uTraceMainInstance ( uTraceInstance ) ;" );
    } // if

    if ( table->symbol->key == TASK ) {
	if ( table->symbol->attribute.value2 & PERIODIC_ATTRIBUTE ) {
	    gen_code( before,
		     "uSleep ( uFirstActivateTime ) ; "
		     "if ( uEndTime == 0 || uThisProcessor ( ) . uGetClock ( ) . uGetTime ( ) < uEndTime ) { "
		     "for ( ; ; ) { "
		     "uTime uStartTime = uThisProcessor ( ) . uGetClock ( ) . uGetTime ( ) + uGetPeriod ( ) ;"
		     );
	} else if ( table->symbol->attribute.value2 & SPORADIC_ATTRIBUTE ) {
	    gen_code( before,
		     "uSleep ( uFirstActivateTime ) ; "
		     "if ( uEndTime == 0 || uThisProcessor ( ) . uGetClock ( ) . uGetTime ( ) < uEndTime ) { "
		     "for ( ; ; ) { "
		     "uTime uStartTime = uThisProcessor ( ) . uGetClock ( ) . uGetTime ( ) + uGetPeriod ( ) ;"
		     );
	} else if ( table->symbol->attribute.value2 & APERIODIC_ATTRIBUTE ) {
	    gen_code( before,
		     "uSleep ( uFirstActivateTime ) ; "
		     "for ( ; ; ) {"
		     );
	} // if
    } // if
} // gen_main_prefix


void gen_main_suffix( token_t * before, symbol_t * symbol ) {
    table_t * table;
    assert( symbol != NULL );
    table = symbol->found;
    assert( table != NULL );
    assert( table->symbol != NULL );

    if ( ( table->symbol->key == COROUTINE ) || ( table->symbol->key == TASK ) ) {
	if ( table->symbol->attribute.value2 & PERIODIC_ATTRIBUTE ) {
	    gen_code( before,
		     "if ( uEndTime != 0 && uEndTime <= uStartTime ) break ; "
		     "uSleep( uStartTime ) ;"
		     );
	    gen_code( before, "} }" );
	} else if ( table->symbol->attribute.value2 & SPORADIC_ATTRIBUTE ) {
	    gen_code( before,
		     "if ( uEndTime != 0 && uEndTime <= uStartTime ) break ;"
		     );
	    gen_code( before, "} }" );
	} else if ( table->symbol->attribute.value2 & APERIODIC_ATTRIBUTE ) {
	    gen_code( before, "}" );
	} // if
	gen_code( before, "}" );
    } // if
} // gen_main_suffix


void gen_constructor_parameter( token_t * before, symbol_t * symbol, bool defarg ) {
    assert( before != NULL );
    assert( before->value == ')' );
    assert( symbol != NULL );

    if ( ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) || ( symbol->index != DESTRUCTORPOSN ) ) {
	token_t * prev = before->prev_parse_token();
	assert( prev != NULL );

	if ( prev->value == '(' ) {
	    gen_code( before, "uAction uConstruct" );
	} else if ( prev->value == VOID ) {
	    prev->remove_token();
	    delete prev;
	    gen_code( before, "uAction uConstruct" );
	} else {
	    gen_code( before, ", uAction uConstruct" );
	} // if
	if ( defarg ) {
	    gen_code( before, "= uYes" );
	} // if
    } // if
} // gen_constructor_parameter


void gen_constructor_prefix( token_t * before, symbol_t * symbol ) {
    assert( symbol != NULL );
    assert( symbol->table != NULL );

    if ( ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) || ( symbol->index != DESTRUCTORPOSN ) ) {
	gen_code( before, "{ uDestruct = uConstruct ;" );
    } // if
    
    if ( ( symbol->key == DUALEVENT ) || ( symbol->key == RAISEEVENT ) || ( symbol->key == THROWEVENT ) ) {
	gen_code( before, "{ uId = &" );
	if ( symbol->base != NULL ) {
	    gen_full_name( before, symbol->base );
	} else {
	    gen_event_kind( before, symbol );
	} // if
	gen_code( before, ":: uId ;" );
    } // if

    // if mutex, generate constructor code
    
    if ( symbol->index != DESTRUCTORPOSN ) {				// is it a monitor?
	gen_code( before, "{ uSerialConstructor uSerialConstructorInstance ( uConstruct , uSerialInstance ) ;" );
    } // if

    // if necessary, generate constructor code
    
    if ( symbol->key == COROUTINE ) {
	gen_code( before, "uCoroutineConstructor uCoroutineConstructorInstance ( uConstruct , * this ," );
	gen_quote_hash( before, symbol->hash );
	gen_code( before, ") ;" );
    } else if ( symbol->key == TASK ) {
	gen_code( before, "uTaskConstructor uTaskConstructorInstance ( uConstruct , uSerialInstance , * this ," );
	gen_quote_hash( before, symbol->hash );
	if ( profile ) {
	    gen_code( before, ", true" );
	} else {
	    gen_code( before, ", false" );
	} // if
	gen_code( before, ") ;" );
    } // if

    // if it is a monitor, a coroutine or a task, and the trace flag is turned on,
    // generate the trace instance constructor.
    
    if ( trace ) {
	if ( ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) || ( symbol->index != DESTRUCTORPOSN ) ) {
	    if ( symbol->key == TASK ) {
		gen_code( before, "uTraceConstructor uTraceConstructorInstance ( uConstruct , true , uTraceInstance ," );
	    } else {
		gen_code( before, "uTraceConstructor uTraceConstructorInstance ( uConstruct , false , uTraceInstance ," );
	    } // if
	    gen_quote_hash( before, symbol->hash );
	    gen_code( before, ", this ) ;" );
	} // if
    } // if
} // gen_constructor_prefix


void gen_constructor_suffix( token_t * before, symbol_t * symbol ) {
    assert( symbol != NULL );

    // if mutex, close the code
    
    if ( symbol->index != DESTRUCTORPOSN ) {
	gen_code( before, "}" );
    } // if
    
    if ( ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) || ( symbol->index != DESTRUCTORPOSN ) ||
	( symbol->key == DUALEVENT ) || ( symbol->key == RAISEEVENT ) || ( symbol->key == THROWEVENT ) ) {
	gen_code( before, "}" );
    } // if
} // gen_constructor_suffix


void gen_mutex( token_t * before, symbol_t * symbol ) {
    if ( symbol->attribute.startE == NULL ) {
	if ( symbol->attribute.value2 != 0 ) {		// => realtime task
	    gen_code( before, "uPrioritySeq uEntryList ;" );
	    gen_code( before, "typedef uPrioritySeq uMutexList ;" );
	} else {
	    gen_code( before, "uBasePrioritySeq uEntryList ;" );
	    gen_code( before, "typedef uBasePrioritySeq uMutexList ;" );
	} // if
    } else {
	token_t *curr = symbol->attribute.startE->next_parse_token();
	symbol->attribute.startE->remove_token();	// remove '<'
	delete symbol->attribute.startE;
	while ( curr != symbol->attribute.startM ) {	// move the entry list type
	    token_t *next = curr->next_parse_token();
	    curr->remove_token();
	    curr->add_token_before( *before );
	    curr = next;
	} // while
	gen_code( before, "uEntryList ;" );

	gen_code( before, "typedef" );
	curr = symbol->attribute.startM->next_parse_token();
	symbol->attribute.startM->remove_token();	// remove ','
	delete symbol->attribute.startM;
	while ( curr != symbol->attribute.endM ) {	// move the mutex list type
	    token_t *next = curr->next_parse_token();
	    curr->remove_token();
	    curr->add_token_before( *before );
	    curr = next;
	} // while
	gen_code( before, "uMutexList ;" );

	symbol->attribute.endM->remove_token();		// remove '>'
	delete symbol->attribute.endM;
    } // if
    gen_code( before, "uSerial uSerialInstance ;" );
} // gen_mutex


void gen_mutex_entry( token_t * before, symbol_t * symbol ) {
    gen_code( before, "uMutexList" );
    gen_entry( before, symbol->index );
    gen_code( before, ";" );
} // gen_mutex_entry


void gen_full_name( token_t * before, symbol_t * symbol ) {
    // print nested qualification names

    for ( table_t *p = symbol->found; ; p = p->symbol->found ) {
      if ( p->symbol == NULL ) break;
	gen_hash( before, p->symbol->hash );

	// if the base type is a template type, output more than just the name of
	// the type. the template definition must also be output. this information
	// is gathered when the type is originally parsed.

	token_t *token = p->symbol->left;
	if ( token != (token_t *)0 ) {
	    for ( ;; ) {
		gen_code( before, token->hash->text );
	      if ( token == p->symbol->right ) break;
		token = token->next_parse_token();
	    } // for
	} // if

	gen_code( before, "::" );
    } // for

    gen_hash( before, symbol->hash );

    // if the base type is a template type, output more than just the name of
    // the type. the template definition must also be output. this information
    // is gathered when the type is originally parsed.

    token_t *token = symbol->left;
    if ( token != (token_t *)0 ) {
	for ( ;; ) {
	    gen_code( before, token->hash->text );
	  if ( token == symbol->right ) break;
	    token = token->next_parse_token();
	} // for
    } // if
} // gen_full_name


void gen_initializer( token_t * before, symbol_t * symbol, char * prefix ) {
    assert( symbol != NULL );

    if ( ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) || ( symbol->index != DESTRUCTORPOSN ) ) {
	symbol_t * base = symbol->base;
	if ( base != NULL && base->table->hasdefault ) {
	    if ( ( base->key == COROUTINE ) || ( base->key == TASK ) || ( base->index != DESTRUCTORPOSN ) ) {
		gen_code( before, prefix );
		gen_full_name( before, base );
		gen_code( before, "( uNo )" );
	    } // if
	} // if
    } // if
} // gen_initializer


void gen_serial_initializer( token_t * before, symbol_t * symbol ) {
    assert( symbol != NULL );

    token_t * after = before->next_parse_token();
    assert( after != NULL );

    if ( symbol->key == TASK || symbol->index != DESTRUCTORPOSN ) { // mutex ?
	if ( symbol->base == NULL ||			// no inheritance ?
	     symbol->base != NULL && ( symbol->base->key != TASK && symbol->base->index == DESTRUCTORPOSN ) ) {
	    token_t * next;

	    // check if there is already a base specifier for this type

	    if ( after->value == ':' ) {
		next = after->next_parse_token();
		assert( next != NULL );
	    } else {
		next = after;
		gen_code( after, ":" );
	    } // if

	    gen_code( next, "uSerialInstance ( uEntryList )" );

	    // insert a comma if the base specifier list is already started

	    if ( after->value == ':' ) {
		gen_code( next, "," );
	    } // if
	} // if
    } // if
} // gen_serial_initializer


void gen_event_kind( token_t * before, symbol_t * symbol ) {
    gen_code( before, symbol->key == DUALEVENT ? "uAEHM :: uDualClass" : symbol->key == RAISEEVENT ? "uAEHM :: uRaiseClass" : "uAEHM :: uThrowClass" );
} // gen_event_kind


void gen_constructor( token_t * before, symbol_t * symbol ) {
    table_t * table;

    assert( symbol != NULL );
    table = symbol->table;
    assert( table != NULL );

    // if necessary, generate a default constructor
    
    if ( ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) || ( symbol->index != DESTRUCTORPOSN ) ||
	 ( symbol->key == DUALEVENT ) || ( symbol->key == RAISEEVENT ) || ( symbol->key == THROWEVENT ) ) {
	token_t * rp;

	symbol->table->hasdefault = true;
	gen_hash( table->public_area, symbol->hash );

	if ( ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) || ( symbol->index != DESTRUCTORPOSN ) ) {
	    gen_code( table->public_area, "( uAction uConstruct = uYes" );
	    gen_code( table->public_area, ")" );
	    rp = table->public_area->prev_parse_token();
	    gen_initializer( table->public_area, symbol, ":" );
	} else {
	    gen_code( table->public_area, "(" );
	    gen_code( table->public_area, ")" );
	    rp = table->public_area->prev_parse_token();
	} // if
	
	gen_serial_initializer( rp, symbol );
	gen_constructor_prefix( table->public_area, symbol );
	gen_code( table->public_area, "{ }" );
	gen_constructor_suffix( table->public_area, symbol );
    } // if
} // gen_constructor


void gen_destructor_prefix( token_t * before, symbol_t * symbol ) {
    assert( symbol != NULL );

    table_t *table = symbol->table;
    assert( table != NULL );

    // if mutex, generate serial destructor code
    
    if ( symbol->index != DESTRUCTORPOSN ) {
	gen_code( before, "{ uSerialDestructor uSerialDestructorInstance ( uDestruct , uSerialInstance ," );
	gen_entry( before, DESTRUCTORPOSN );
	gen_code( before, "," );
	gen_mask( before, DESTRUCTORPOSN );
	gen_code( before, ") ;" );
    } // if

    if ( trace && ( symbol->index != DESTRUCTORPOSN || symbol->key == COROUTINE ) ) { // trace mutex and coroutine destructors
	if ( symbol->index == DESTRUCTORPOSN ) {			// not mutex ?
	    gen_code( before, "{" );
	} // if
	gen_code( before, "uTraceDestructor uTraceDestructorInstance ( uDestruct , uTraceInstance ) ;" );
    } // if

    // if task, generate task destructor code

    if ( symbol->key == TASK ) {
	gen_code( before, "uTaskDestructor uTaskDestructorInstance ( uDestruct , ( uBaseTask & ) * this ) ;" );
    } // if
} // gen_destructor_prefix


void gen_destructor_suffix( token_t * before, symbol_t * symbol ) {
    assert( symbol != NULL );

    // if destructor code is generated, close the code
    
    if ( symbol->index != DESTRUCTORPOSN || ( trace && symbol->key == COROUTINE ) ) {
	gen_code( before, "}" );
    } // if
} // gen_destructor_suffix


void gen_destructor( token_t * before, symbol_t * symbol ) {
    table_t * table;
    
    assert( symbol != NULL );
    table = symbol->table;
    assert( table != NULL );

    // if necessary, generate a default destructor

    if ( ( symbol->index != DESTRUCTORPOSN ) || ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) ) {
	gen_code( table->public_area, "~" );
	gen_hash( table->public_area, symbol->hash );
	gen_code( table->public_area, "( )" );
	gen_destructor_prefix( table->public_area, symbol );
	gen_code( table->public_area, "{ }" );
	gen_destructor_suffix( table->public_area, symbol );
    } // if
} // gen_destructor


void gen_class_prefix( token_t * before, symbol_t * symbol ) {
    table_t * table;
    
    assert( symbol != NULL );
    table = symbol->table;
    assert( table != NULL );

    gen_code( before, "private :" );
    gen_code( before, "protected :" );
    gen_code( before, "public :" );

    switch( symbol->key ) {
      case STRUCT:
      case UNION:
	gen_code( before, "public :" );
	break;
      case CLASS:
      case COROUTINE:
      case TASK:
      case DUALEVENT:
      case RAISEEVENT:
      case THROWEVENT:
	gen_code( before, "private :" );
	break;
      default:
	assert( 0 );
	break;
    } // switch

    table->public_area = before->prev_parse_token();
    table->protected_area = table->public_area->prev_parse_token();
    table->private_area = table->protected_area->prev_parse_token();
} // gen_class_prefix


void gen_destruct( token_t * before, symbol_t * symbol ) {
    gen_code( before, "uAction uDestruct ;" );
    if ( ! symbol->table->hascopy ) {			// no copy operator ?
	gen_code( before, symbol->hash->text );
	gen_code( before, "(" );
	gen_code( before, symbol->hash->text );
	gen_code( before, "& ) ;" );
    } // if
    if ( ! symbol->table->haseqop ) {			// no equal operator ?
	gen_code( before, symbol->hash->text );
	gen_code( before, "& operator = (" );
	gen_code( before, symbol->hash->text );
	gen_code( before, "& ) ;" );
    } // if
} // gen_destruct


void gen_class_suffix( token_t * before, symbol_t * symbol ) {
    table_t * table;

    assert( symbol != NULL );
    table = symbol->table;
    assert( table != NULL );

    if ( symbol->key == DUALEVENT || symbol->key == RAISEEVENT || symbol->key == THROWEVENT ) {
	gen_code( table->public_area, "static void * uId ;" );
	gen_code( table->protected_area, "virtual void * uEvent_id ( ) const { return & uId ; }" );
	gen_code( table->protected_area, "virtual" );
	gen_event_kind( table->protected_area, symbol );
	gen_code( table->protected_area, "* uDuplicate ( ) const { return new" );
	gen_hash( table->protected_area, symbol->hash );
	gen_code( table->protected_area, "( * this ) ; }" );

	if ( symbol->key == DUALEVENT || symbol->key == THROWEVENT ) {
	    gen_code( table->protected_area,
		     "virtual void uStackThrow ( ) const { "
		     "uThisCoroutine ( ) . uThrowEventCnt += 1 ; "
		     "uAEHM :: uThrowLock -> uAcquire ( ) ; "
		     "throw * this ; }"
		     );
	} // if
    } // if

    // if necessary, generate the trace code

    if ( trace ) {
	if ( symbol->key == TASK ) {
	    if ( symbol->base == NULL ) {		// only in base constructor
		gen_code( table->protected_area, "uTrace uTraceInstance ;" );
	    } // if
	} else if ( ( symbol->index != DESTRUCTORPOSN ) || ( symbol->key == COROUTINE ) ) {
	    if ( symbol->base == NULL ) {		// only in base constructor
		gen_code( table->protected_area, "uTrace uTraceInstance ;" );
	    } // if
	} // if
    } // if

    // force mutex destructor for all mutex type if no mutex members

    if ( ( symbol->index == DESTRUCTORPOSN ) && ( symbol->attribute.value == MUTEX_ATTRIBUTE ) ) {
	gen_mutex( table->protected_area, symbol );
	gen_mutex_entry( table->protected_area, symbol );
	symbol->index += 1;
    } // if

    // generate either the default destructor or the supplied destructors
    
    if ( table->destructor.empty_structor_list() ) {
	gen_destructor( table->public_area, symbol );
    } else {
	while ( ! table->destructor.empty_structor_list() ) {
	    structor_t * structor = table->destructor.remove_structor();

	    if ( ( structor->value & NOMUTEX_ATTRIBUTE ) && ( symbol->index != DESTRUCTORPOSN ) ) {
		gen_error( ahead, "destructor of mutex type must be mutex, uNoMutex attribute ignored" );
	    } // if
	    if ( structor->prefix != NULL ) {
		gen_destructor_prefix( structor->prefix, symbol );
		gen_destructor_suffix( structor->suffix, symbol );
	    } // if

	    delete structor;
	} // while
    } // if

    // generate the default constructor, or add the required code to the
    // constructors seen thus far
    
    if ( table->constructor.empty_structor_list() ) {
	gen_constructor( table->public_area, symbol );
    } else {
	while ( ! table->constructor.empty_structor_list() ) {
	    structor_t * structor = table->constructor.remove_structor();

	    gen_constructor_parameter( structor->rp, symbol, true );
	    
	    if ( structor->prefix != NULL ) {
		gen_constructor_prefix( structor->prefix, symbol );
		gen_constructor_suffix( structor->suffix, symbol );
	    } // if

	    delete structor;
	} // while
    } // if

    // generate the default destructor or add the required code to this code
    // because it has to come after generating the destructors and constructors
    // as that code may cause the class to become mutex

    // if this is a mutex, coroutine or task, generate the prefix declarations

    if ( ( symbol->index != DESTRUCTORPOSN ) || ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) ) {
	gen_destruct( table->private_area, symbol );
    } // if
} // gen_class_suffix


void gen_wait_prefix( token_t * before, token_t * after ) {
    if ( trace ) {
	gen_code( before, "{ uTraceAcceptStart uTraceAcceptStartInstance ( uTraceInstance ) ;" );
    } // if

    gen_code( before, "(" );
    gen_code( after, ") . uW ( uSerialInstance" );
} // gen_wait_prefix

void gen_with( token_t * before, token_t * after ) {
    gen_code( before, ", (" );
    gen_code( after, ")" );
} // gen_with

void gen_wait_suffix( token_t * before ) {
    gen_code( before, ")" );

    if ( trace ) {
	gen_code( before, "; { uTraceAcceptDone uTraceAcceptDoneInstance ( uTraceInstance ) ; } }" );
    } // if
} // gen_wait_suffix


void gen_signal_prefix( token_t * before ) {
    gen_code( before, "(" );
} // gen_signal_prefix

void gen_signal_suffix( token_t * before ) {
    gen_code( before, ") . uS ( uSerialInstance )" );
} // gen_signal_suffix


void gen_signalblock_prefix( token_t * before ) {
    gen_code( before, "(" );
} // gen_signalblock_prefix

void gen_signalblock_suffix( token_t * before ) {
    gen_code( before, ") . uSBlock ( uSerialInstance )" );
} // gen_signalblock_suffix


void gen_suspend_prefix( token_t * before, symbol_t *symbol ) {
    gen_code( before, "{" );
    if ( trace ) {
	gen_code( before, "uTraceSuspend uTraceSuspendInstance ( uTraceInstance ," );
 	gen_quote_hash( before, symbol->hash );
 	gen_code( before, ") ;" );
    } // if
    gen_code( before, "uCoSuspend ( )" );
} // gen_suspend_prefix

void gen_suspend_suffix( token_t * before, symbol_t *symbol ) {
    gen_code( before, "}" );
} // gen_suspend_suffix


void gen_resume_prefix( token_t * before, symbol_t *symbol ) {
    gen_code( before, "{" );
    if ( trace ) {
	gen_code( before, "uTraceResume uTraceResumeInstance ( uTraceInstance ," );
 	gen_quote_hash( before, symbol->hash );
 	gen_code( before, ") ;" );
    } // if
    gen_code( before, "uCoResume ( )" );
} // gen_resume

void gen_resume_suffix( token_t * before, symbol_t *symbol ) {
    gen_code( before, "}" );
} // gen_resume


void gen_verify( token_t * before ) {
    gen_code( before, "uThisCoroutine ( ) . uVerify ( ) ;" );
} // gen_verify


void gen_yield( token_t * before ) {
    gen_code( before, "uThisTask ( ) . uYieldYield ( rand () % 3 ) ;" );
} // gen_yield


void gen_uthrow_prefix( token_t * before, token_t * after ) {
    gen_code( before, "uAEHM :: uAEThrow (" );
} // gen_uthrow_prefix

void gen_uthrow_uat_prefix( token_t * before, token_t * after ) {
    gen_code( before, "uAEHM :: uAEThrow (" );
    gen_code( after, "," );
} // gen_uthrow_uat_prefix

void gen_uthrow_suffix( token_t * before ) {
    gen_code( before, ")" );
} // gen_uthrow_suffix


void gen_raise_prefix( token_t * before, token_t * after ) {
    gen_code( before, "uAEHM :: uAERaise (" );
} // gen_raise_prefix

void gen_raise_uat_prefix( token_t * before, token_t * after ) {
    gen_code( before, "uAEHM :: uAERaise (" );
    gen_code( after, "," );
} // gen_raise_uat_prefix

void gen_raise_suffix( token_t * before ) {
    gen_code( before, ")" );
} // gen_raise_suffix


// Local Variables: //
// compile-command: "dmake" //
// End: //
