//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Nikita Borisov 1995
// 
// cpp.c -- 
// 
// Author           : Nikita Borisov
// Created On       : Sat Dec  9 13:32:00 1995
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 23 11:41:43 1999
// Update Count     : 303
// 


#include <iostream.h>
#include <stdio.h>					// FILENAME_MAX, sprintf, freopen, perror
#include <stdlib.h>					// getenv, putenv
#include <unistd.h>					// getpid, execvp, execve, fork, unlink
#include <sys/wait.h>					// wait

#include <string.h>
#include <string>					// STL version


#if ! defined( FILENAME_MAX ) || defined( __hp__ )	// TEMPORARY, come on HP get this right!
#define FILENAME_MAX 1024
#endif


//#define __U_DEBUG_H__


static char *uTmpnam() {
    static char name[FILENAME_MAX];
    static int cnt = 0;

    cnt += 1;						// unique numbering per application

    char *tmpdir = getenv( "TMPDIR" );
    if ( tmpdir == (char *)0 ) {			// check for environment variable
	tmpdir = TMPDIR;				// use default
    } // if

    strcpy( name, tmpdir );
    if ( tmpdir[strlen( tmpdir ) - 1] != '/' ) {	// trailing slash ?
	strcat( name, "/" );				// add slash
    } // if

    strcat( name, "uC++" );				// add prefix
    sprintf( &name[strlen(name)], "%.3d%.6d", cnt, getpid() ); // add unique qualifies
    return name;
} // uTmpnam


int main( int argc, char *argv[] ) {
    int code;
    int i;

    string arg;
    string bprefix;

    string cpp_in;
    string cpp_out;
    string cpp;
    string cpp_name( "g++" );

    bool upp_flag = false;
    bool cpp_flag = false;
    bool gnu = false;
    bool start = false;

    const char *args[argc + 100];			// leave space for 100 additional u++ command line values
    int nargs = 1;					// 0 => command name
    const char *argsCppOnly[argc];			// cpp only arguments
    int nargsCppOnly = 0;

    // get a name of a temporary file

    char *tmpfile = uTmpnam();

    // process all the arguments

    for ( i = 1; i < argc; i += 1 ) {
#ifdef __U_DEBUG_H__
	cerr << "argv[" << i << "]:\"" << argv[i] << "\"" << endl;
#endif __U_DEBUG_H__
	arg = argv[i];
#ifdef __U_DEBUG_H__
	cerr << "arg:\"" << arg << "\"" << endl;
#endif __U_DEBUG_H__
	if ( arg.substr(0,1) == "-" ) {
	    if ( arg == "-D__U_UPP__" ) {
		upp_flag = true;			// strip the -D__U_UPP__ flag
	    } else if ( arg == "-D__U_CPP__" ) {
		cpp_flag = true;			// strip the -D__U_CPP__ flag
	    } else if ( arg.substr(0,3) == "-o" ) {
		i += 1;					// strip the -o flag and its argument
	    } else if ( arg == "-v" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg.substr(0,2) == "-I" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-C" || arg == "-P" || arg == "-H" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg.substr(0,2) == "-W" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-lint" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg.substr(0,7) == "-D__GNU" ) {
		gnu = true;
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
	    } else if ( arg == "-pedantic" || arg == "-pedantic-errors" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-traditional" || arg == "-trigraphs" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-dM" || arg == "-dD" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-M" || arg == "-MG" || arg == "-MM" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-MD" || arg == "-MMD" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
		i += 1;
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-imacros" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
		i += 1;
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-include" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
		i += 1;
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-idirafter" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
		i += 1;
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-iprefix" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
		i += 1;
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-iwithprefix" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
		i += 1;
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg == "-isystem" ) {
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
		i += 1;
		argsCppOnly[nargsCppOnly] = argv[i];	// pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg.substr(0,19) == "-D__U_GCC_BPREFIX__" ) {
		bprefix = arg.substr( 19+1 );
	    } else if ( arg.substr(0,19) == "-D__U_GCC_MACHINE__" ) {
		argsCppOnly[nargsCppOnly] = "-b";	// pass the argument along
		nargsCppOnly += 1;
		argsCppOnly[nargsCppOnly] = ( *new string( arg.substr( 19+1 ) ) ).c_str(); // pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg.substr(0,19) == "-D__U_GCC_VERSION__" ) {
		argsCppOnly[nargsCppOnly] = "-V";	// pass the argument along
		nargsCppOnly += 1;
		argsCppOnly[nargsCppOnly] = ( *new string( arg.substr( 19+1 ) ) ).c_str(); // pass the argument along
		nargsCppOnly += 1;
	    } else if ( arg.substr(0,16) == "-D__U_CPP_NAME__" ) {
		cpp_name = arg.substr( 16+1 );
	    } else if ( arg.substr(1,1) != "+" ) {
		if ( arg == "-D__U_CPP_FLAGS__" ) {	// start of user cpp flags
		    start = true;
		} // if
		if ( start ) {
		    args[nargs] = argv[i];		// pass the argument along
		    nargs += 1;
		} // if
	    } // if
	} else {
	    if ( cpp_in.length() == 0 ) {
		cpp_in = arg;
#ifdef __U_DEBUG_H__
		cerr << "cpp_in:\"" << cpp_in << "\"" << endl;
#endif __U_DEBUG_H__
	    } else if ( cpp_out.length() == 0 ) {
		cpp_out = arg;
#ifdef __U_DEBUG_H__
		cerr << "cpp_out:\"" << cpp_out << "\""<< endl;
#endif __U_DEBUG_H__
	    } else {
		cerr << "Usage: " << argv[0] << " input-file [output-file] [options]" << endl;
		exit( 1 );
	    } // if
	} // if
    } // for

    if ( cpp_in.length() == 0 ) {
	cerr << "Usage: " << argv[0] << " input-file [output-file] [options]" << endl;
	exit( 1 );
    } // if

    if ( cpp_flag && upp_flag ) {
	cerr << argv[0] << " Error cannot use -E and -U++ flags together." << endl;
	exit( -1 );
    } // if

    // The -E flag is specified so only run the preprocessor and output is
    // written to standard output.
    //
    // OR
    //
    // The preprocessor is called internally during compilation, probably by
    // "collect" during linking to compile some ctor/dtor code. In this case,
    // the u++-cpp preprocessor is not run.  Output is redirected to cpp_out

    if ( cpp_flag || bprefix.length() == 0 ) {
	if ( ! cpp_flag ) {
	    if ( freopen( cpp_out.c_str(), "w", stdout ) == NULL ) { // redirect stdout if not -E
		cerr << argv[0] << ": Error can't write to " << cpp_out << endl;
		exit( -1 );
	    } // fi

	    // If called by collect, must prevent the compiler from recursively
	    // calling this cpp through the -B path. To stop the recursion,
	    // sent the COMPILER_PATH environment variable to the NULL string,
	    // which removes the -B path supplied on the initial u++ command.

	    if ( gnu ) {
		putenv( "COMPILER_PATH=" );
	    } // if
	} // fi

	args[0] = cpp_name.c_str();
	args[nargs] = "-E";
	nargs += 1;

	for ( i = 0; i < nargsCppOnly; i += 1 ) {	// copy cpp only arguments
	    args[nargs] = argsCppOnly[i];
	    nargs += 1;
	} // if

	args[nargs] = cpp_in.c_str();
	nargs += 1;
	args[nargs] = NULL;				// terminate argument list

#ifdef __U_DEBUG_H__
	cerr << "nargs: " << nargs << endl;
	for ( i = 0; args[i] != NULL; i += 1 ) {
	    cerr << args[i] << " ";
	} // for
	cerr << endl;
#endif __U_DEBUG_H__

	execvp( args[0], (char *const *)args );		// should not return
	perror( "uC++ translator error: cpp level, exec" );
	exit( -1 );
    } // if

    // Run the C preprocessor and save the output in tmpfile.

    if ( fork() == 0 ) {				// child process ?
	if ( freopen( tmpfile, "w", stdout ) == NULL) {	// redirect output to tmpfile
	    cerr << argv[0] << ": Error can't write to " << tmpfile << endl;
	    exit( -1 );
	} // if

	args[0] = cpp_name.c_str();
	args[nargs] = "-E";
	nargs += 1;

	for ( i = 0; i < nargsCppOnly; i += 1 ) {	// copy cpp only arguments
	    args[nargs] = argsCppOnly[i];
	    nargs += 1;
	} // if

	args[nargs] = cpp_in.c_str();
	nargs += 1;
	args[nargs] = NULL;				// terminate argument list

#ifdef __U_DEBUG_H__
	cerr << "cpp nargs: " << nargs << endl;
	for ( i = 0; args[i] != NULL; i += 1 ) {
	    cerr << args[i] << " ";
	} // for
	cerr << endl;
#endif __U_DEBUG_H__

	execvp( args[0], (char *const *)args );		// should not return
	perror( "uC++ translator error: cpp level, exec" );
	exit( -1 );
    } // if

    wait( &code );					// wait for child to finish

    if ( WIFSIGNALED(code) != 0 ) {			// child completed successfully ?
	unlink( tmpfile );
	fprintf( stderr, "uC++ translator error: cpp failed with signal %d\n", WTERMSIG(code) );
	exit( -1 );
    } // if

    // If -U++ flag specified, run the u++-cpp preprocessor on the temporary
    // file, and output is written to standard output.  Otherwise, run the
    // u++-cpp preprocessor on the temporary file and save the result into the
    // output file.

    if ( fork() == 0 ) {				// child process ?
	args[0] = ( *new string( bprefix + "/u++-cpp" ) ).c_str();
	args[nargs] = tmpfile;
	nargs += 1;

	if ( ! upp_flag ) {				// run u++-cpp ?
	    args[nargs] = cpp_out.c_str();
	    nargs += 1;
	} // if
	args[nargs] = NULL;				// terminate argument list

#ifdef __U_DEBUG_H__
	cerr << "u++-cpp nargs: " << nargs << endl;
	for ( i = 0; args[i] != NULL; i += 1 ) {
	    cerr << args[i] << " ";
	} // for
	cerr << endl;
#endif __U_DEBUG_H__

	execvp( args[0], (char *const *)args );		// should not return
	perror( "uC++ translator error: cpp level, exec" );
    } // if

    wait( &code );					// wait for child to finish

    unlink( tmpfile );

    if ( WIFSIGNALED(code) != 0 ) {			// child completed successfully ?
	fprintf( stderr, "uC++ translator error: u++-cpp failed with signal %d\n", WTERMSIG(code) );
	exit( -1 );
    } // if

    if ( upp_flag ) {					// -U++ flag ?
	exit( -1 );					// tell gcc not to go any further
    } else {
	exit( WEXITSTATUS(code) );
    } // if
} // main


// Local Variables: //
// compile-command: "dmake" //
// End: //
