//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// assert.h -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 16:01:41 1992
// Last Modified By : Peter Buhr
// Last Modified On : Mon Jul  4 18:10:26 1994
// Update Count     : 15
// 

#ifndef __ASSERT_H__
#define __ASSERT_H__

#ifdef DEBUG

#include "gen.h"
#include "output.h"

#define assert( condition ) \
    if ( ! ( condition ) ) { \
	fprintf( stderr, "%s:%u: assertion failed\n", __FILE__, __LINE__ ); \
        gen_error( ahead, "assertion failed at this line" ); \
        write_all_output(); \
        exit( -1 ); \
    } // if

#else

#define assert( condition )

#endif DEBUG

#endif __ASSERT_H__

// Local Variables: //
// compile-command: "dmake" //
// End: //
