//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uCollect.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Jun 29 12:40:15 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 14 15:11:52 1997
// Update Count     : 411
// 


#ifndef __U_COLLECT_H__
#define __U_COLLECT_H__


#include "uTable.h"					// for event types


class uSocketClient;					// forward declaration


//######################### uTrace #########################


class uTrace {
    friend uTask uCollector;				// classes that need access to internal variables
    friend class uTraceConstructor;
    friend class uTraceResume;
    friend class uTraceSuspend;
    friend class uTraceEntry;
    friend class uTraceMain;

    int debugID;					// trace line ID
    int messageNo;					// event number generator for this object
    bool nativeThread;					// does entity have a native thread
    int threads;					// number of threads active and blocked in mutex object
    uTrace *resumer;					// used by coroutines to remember the resumer

    void *operator new( size_t, void *storage ) { return storage; }
    void *operator new( size_t size ) { return ::operator new( size ); }
  public:
    int uCount() {
	int temp = messageNo;
        messageNo += 1;
	return temp;
    } // uTrace::uCount
}; // uTrace


//######################### uCollector #########################


uTask uCollector {
    friend class uCollectorBoot;			// classes that need access to internal variables
    friend class uTraceContext;
    friend class uTraceConstructor;
    friend class uTraceDestructor;
    friend class uTraceAcceptStart;
    friend class uTraceAcceptDone;
    friend class uTraceResume;
    friend class uTraceSuspend;
    friend class uTraceEntry;
    friend class uTracePetition;
    friend class uTraceMain;
    friend class uBaseCoroutine;

    // System identification: uninterpreted byte string to identify what system
    // an event came from.

    struct interpname {
	unsigned long int hostid;
	long int rootprocess;
    };

    struct EVENT_ZERO {
	struct {
	    int magic_int;				// MAGIC_INT, determine byte order
	    char magic_str[4];				// MAGIC_STR, determine character code
	    int target_id;				// identifier for target environment
	    int stream_len;				// length of stream identifier
	    int trace_len;				// length of trace identifier
	    int text_len;				// length of text in a text event
	    unsigned flags;				// miscellaneous flags
	} hdr;
	interpname stream_id;
    };

    struct EVENT {
	struct {
	    int e_etype;				// event type
	    int e_evcnt;				// local event count
	    int e_sevcnt;				// partner event count
	} hdr;
	int e_trace;					// event trace
	interpname e_interp;
	int e_ptrace;
    };

    struct NAME_EVENT {
	int  e_etype;					// event type
	char e_name[32];				// name text
    };

    static uCollector *uCollectorServer;		// unique collector for trace events

    interpname localaddr;				// unique system id
    EVENT event;					// simple event
    struct {
	EVENT ev;
	NAME_EVENT nev;
    } eventnamed;					// named event

    char *portNo, *host;				// communication
    uSocketClient *sockClient;				// pointer to trace socket (don't create socket if not tracing)

    void main();
  public:
    uCollector( char *port_string, char *host_string );
    ~uCollector();
    
    void uEvent( uTrace &sender, unsigned e_type, int p_trace, int p_evcnt );
    uNoMutex void uEventNoPartner( uTrace &sender, unsigned e_type );
    void uEventNamed( uTrace &sender, unsigned e_type, int p_trace, int p_evcnt, const char *name, void *addr );
    uNoMutex void uEventNoPartnerNamed( uTrace &sender, unsigned e_type, const char *name, void *addr );
}; // uCollector


//######################### uCollector Boot #########################


class uCollectMimicTask;				// forward declaration

class uCollectorBoot {
    static int uCount;
    uCollectMimicTask *mimic;
  public:
    uCollectorBoot();
    ~uCollectorBoot();
}; // uCollectorBoot


//######################### Runtime Trace Definitions #########################


class uTraceConstructor {
  public:
    uTraceConstructor( int action, bool nativeThread, uTrace &trace, const char *name, void *addr );
}; // uTraceConstructor

class uTraceDestructor {
  public:
    uTraceDestructor( int action, uTrace &trace );
}; // uTraceDestructor

class uTraceAcceptStart {
  public:
    uTraceAcceptStart( uTrace &trace );
}; // uTraceAcceptStart

class uTraceAcceptDone {
  public:
    uTraceAcceptDone( uTrace &trace );
}; // uTraceAcceptDone

class uTraceResume {
    uTrace &trace;
  public:
    uTraceResume( uTrace &t, const char *rtnName );
}; // uTraceResume

class uTraceSuspend {
  public:
    uTraceSuspend( uTrace &trace, const char *rtnName );
}; // uTraceSuspend

class uTraceEntry {
    uTrace &trace, &old;
    const char *rtnName;
  public:
    uTraceEntry( uTrace &t, const char *rtnName );
    ~uTraceEntry();
}; // uTraceEntry

class uTracePetition {
  public:
    uTracePetition();
}; // uTracePetition

class uTraceMain {
    uTrace &trace, *first;
  public:
    uTraceMain( uTrace &t );
    ~uTraceMain();
}; // uTraceMain


#endif __U_COLLECT_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
