//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uCollect.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Jun 29 12:22:14 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Nov 27 10:19:24 1997
// Update Count     : 679
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uCollect.h>
#include <uSocket.h>
//#include <uDebug.h>

#include <string.h>
#include <stdlib.h>
#include <unistd.h>					// getpid
#include <stdio.h>					// sprintf
#ifdef __svr4__
#include <sys/systeminfo.h>
#include <netinet/in.h>
#endif __svr4__


//######################### uEventNames #########################


uMonitor uEventNames {
    friend class uTraceConstructor;			// access: uEventNameServer
    friend class uCollectorBoot;			// access: uEventNameServer

    static uEventNames *uEventNameServer;		// unique event name generator

    int nextName;
  public:
    uEventNames() : nextName( 1 ) {
    } // uEventNames::uEventNames()
    
    int next() {					// generate unique IDs (names) for each trace line object
	if ( nextName == -1 ) {				// -1 is reserved
	    nextName += 1;
	} // if
	int temp = nextName;
	nextName += 1;
	return temp;
    } // uEventNames::next
}; // uEventNames


uEventNames *uEventNames::uEventNameServer = (uEventNames *)0;


//######################### uCollector #########################


#define MAGIC_INT 314
#define MAGIC_STR "ANY1"


void uCollector::main() {
    unsigned short port = atoi( portNo );
    struct hostent hp;
    if ( uGethostbyname( host, &hp ) == -1 ) {	// get internet address for host name
	uAbort( "(uCollector &)0x%p.main(): host address failure", this );
    } // if

    localaddr.hostid = ((unsigned char)hp.h_addr_list[0][0] << 24) | ((unsigned char)hp.h_addr_list[0][1] << 16) |
	               ((unsigned char)hp.h_addr_list[0][2] << 8)  |  (unsigned char)hp.h_addr_list[0][3]; // event machine name
    localaddr.rootprocess = getpid();			// root process on machine

    sockClient = new uSocketClient( port, host, *uKernelModule::uSystemCluster );

    // create and send the initialization event (event zero).

    EVENT_ZERO ev0;

    ev0.hdr.magic_int = MAGIC_INT;
    strncpy( ev0.hdr.magic_str, MAGIC_STR, sizeof(ev0.hdr.magic_str) );
    ev0.hdr.target_id = __DBG_TARGETID__;
    ev0.hdr.stream_len = sizeof(interpname);
    ev0.hdr.trace_len = sizeof(int);
    ev0.hdr.text_len = sizeof(NAME_EVENT::e_name);
    ev0.hdr.flags = 0;
    ev0.stream_id = localaddr;

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uCollector &)0x%p.main, magic_int:%d, magic_str:%s, target_id:%d, stream_len:%d, trace_len:%d, text_len:%d, flags:%d, hostid:%d, rootprocess:%d\n",
	       this, ev0.hdr.magic_int, ev0.hdr.magic_str, ev0.hdr.target_id, ev0.hdr.stream_len, ev0.hdr.trace_len,
	       ev0.hdr.text_len, ev0.hdr.flags, localaddr.hostid, localaddr.rootprocess );
//    uDebugPrt( "sizeof(ev0):%d, ev0:", sizeof(ev0) );
//    uDebugAcquire();
//    for ( int i = 0; i < sizeof(ev0)/4; i += 1 ) {
//	uDebugPrt2( "%.8x ", ((int *)&ev0)[i] );
//    } // for
//    uDebugPrt2( "\n" );
//    uDebugRelease();
#endif __U_DEBUG_H__

    sockClient->write( (char *)&ev0, sizeof(ev0) );

    for ( ;; ) {
	uAccept( ~uCollector ) {
	    break;
	} uOr uAccept( uEvent ) {
	    sockClient->write( (char *)&event, sizeof(event) );
	} uOr uAccept( uEventNamed ) {
	    sockClient->write( (char *)&eventnamed, sizeof(eventnamed) );
	} // uAccept
    } // for

    delete sockClient;
} // uCollector::main

uCollector::uCollector( char *portNo, char *host ) : uBaseTask( *uKernelModule::uSystemCluster ), portNo( portNo ), host( host )  {
} // uCollector::uCollector

uCollector::~uCollector() {
} // uCollector::~uCollector

void uCollector::uEvent( uTrace &sender, unsigned e_type, int p_trace, int p_evcnt ) {
    event.hdr.e_etype = e_type;
    event.hdr.e_evcnt = sender.uCount();
    event.hdr.e_sevcnt = p_evcnt;
    event.e_trace = sender.debugID;
    event.e_interp = localaddr;
    event.e_ptrace = p_trace;

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uCollector &)0x%p.uEvent, e_etype:%d, e_evcnt:%d, p_evcnt:%d, e_trace:%d, e_interp:%d,%d, e_ptrace:%d\n",
	       this, event.hdr.e_etype, event.hdr.e_evcnt, event.hdr.e_sevcnt, event.e_trace,
	       event.e_interp.hostid, event.e_interp.rootprocess, event.e_ptrace );
//    uDebugPrt( "sizeof(event):%d, event:", sizeof(event) );
//    uDebugAcquire();
//    for ( int i = 0; i < sizeof(event)/4; i += 1 ) {
//	uDebugPrt2( "%.8x ", ((int *)&event)[i] );
//    } // for
//    uDebugPrt2( "\n" );
//    uDebugRelease();
#endif __U_DEBUG_H__
} // uCollector::uEvent

void uCollector::uEventNamed( uTrace &sender, unsigned e_type, int p_trace, int p_evcnt, const char *name, void *addr ) {
    eventnamed.ev.hdr.e_etype = e_type;
    eventnamed.ev.hdr.e_evcnt = sender.uCount();
    eventnamed.ev.hdr.e_sevcnt = p_evcnt;
    eventnamed.ev.e_trace = sender.debugID;
    eventnamed.ev.e_interp = localaddr;
    eventnamed.ev.e_ptrace = p_trace;
    
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uCollector &)0x%p.uEventNamed, e_etype:%d, e_evcnt:%d, p_evcnt:%d, e_trace:%d, e_interp:%d,%d, e_ptrace:%d\n",
	       this, eventnamed.ev.hdr.e_etype, eventnamed.ev.hdr.e_evcnt, eventnamed.ev.hdr.e_sevcnt, eventnamed.ev.e_trace,
	       eventnamed.ev.e_interp.hostid, eventnamed.ev.e_interp.rootprocess, eventnamed.ev.e_ptrace );
#endif __U_DEBUG_H__
    
    eventnamed.nev.e_etype = e_type | __DBG_TEXT__;
    if ( addr != NULL ) {
	char tempname[256];
	sprintf( tempname, "%s(0x%p)", name, addr );
	strncpy( eventnamed.nev.e_name, tempname, sizeof(eventnamed.nev.e_name) );
    } else {
	strncpy( eventnamed.nev.e_name, name, sizeof(eventnamed.nev.e_name) );
    } // if

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uCollector &)0x%p.uEventNamed, e_type:%d, e_name:%s\n", this, eventnamed.nev.e_etype, eventnamed.nev.e_name );
//    uDebugPrt( "sizeof(eventnamed):%d, eventnamed:", sizeof(eventnamed) );
//    uDebugAcquire();
//    for ( int i = 0; i < sizeof(eventnamed)/4; i += 1 ) {
//	uDebugPrt2( "%.8x ", ((int *)&eventnamed)[i] );
//    } // for
//    uDebugPrt2( "\n" );
//    uDebugRelease();
#endif __U_DEBUG_H__
} // uCollector::uEventNamed

void uCollector::uEventNoPartner( uTrace &sender, unsigned e_type ) {
    uEvent( sender, e_type, -1, 0 );			// no partner event
} // uCollector::uEventNoPartner

void uCollector::uEventNoPartnerNamed( uTrace &sender, unsigned e_type, const char *name, void *addr ) {
    uEventNamed( sender, e_type, -1, 0, name, addr );	// no partner event
} // uCollector::uEventNoPartnerNamed


uCollector *uCollector::uCollectorServer = (uCollector *)0;


//######################### uCollectorBoot #########################


// SKULLDUGGERY: The boot task has already started execution but could not
// register with the event collector because the collector is just being
// initialized. Therefore, all the trace data structures for the boot task are
// mimicked outside of the boot task. (HA!)

class uCollectMimicTask {
    class uCollectMimicTaskMain {
	uTraceMain tracemain;
      public:
	uCollectMimicTaskMain( uTrace &uTraceInstance ) : tracemain( uTraceInstance ) {}
    }; // uCollectMimicTaskMain
    uTrace uTraceInstance;
    uCollectMimicTaskMain *mimic;
  public:
    uCollectMimicTask() {
	uTraceConstructor( uYes, true, uTraceInstance, uThisTask().uGetName(), &uThisTask() );
	mimic = new uCollectMimicTaskMain( uTraceInstance );
    } // uCollectMimicTask::uCollectMimicTask
    ~uCollectMimicTask() {
	delete mimic;
	uTraceDestructor( uYes, uTraceInstance );
    } // uCollectMimicTask::~uCollectMimicTask
}; // uCollectMimicTask


uCollectorBoot::uCollectorBoot() {
    uCount += 1;
    if ( uCount == 1 ) {
	char *port = getenv( "_HDEBUG_PORT" );
	char *host = getenv( "_HDEBUG_HOST" );

	// If the magic environment variables exists, the event tracer is
	// running and this application can connect to it through a socket.

	if ( port != (char *)0 && host != (char *)0 ) {
#ifdef __U_DEBUG_H__
	    uDebugPrt( "(uCollectorBoot &)0x%p, port:%s, host:%s\n", this, port, host );
#endif __U_DEBUG_H__
	    uEventNames::uEventNameServer = new uEventNames;
	    uCollector::uCollectorServer = new uCollector( port, host );
	    mimic = new uCollectMimicTask;		// create the fake trace structures for the boot task
	} // if
    } // if
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uCollectorBoot &)0x%p.uCollectorBoot\n", this );
#endif __U_DEBUG_H__
} // uCollectorBoot::uCollectorBoot

uCollectorBoot::~uCollectorBoot() {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uCollectorBoot &)0x%p.~uCollectorBoot\n", this );
#endif __U_DEBUG_H__
    uCount -= 1;
    if ( uCount == 0 ) {
	if ( uCollector::uCollectorServer != (uCollector *)0 ) {
	    delete mimic;
	    delete uCollector::uCollectorServer;
	    uCollector::uCollectorServer = (uCollector *)0; // no more calls to event collector
	    delete uEventNames::uEventNameServer;
	    uEventNames::uEventNameServer = (uEventNames *)0; // no more calls to event name generator
	} // if
    } // if
} // uCollectorBoot::~uCollectorBoot


int uCollectorBoot::uCount = 0;


//######################### Runtime Trace Definitions #########################


uTraceConstructor::uTraceConstructor( int action, bool nativeThread, uTrace &trace, const char *name, void *addr ) {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    if ( action ) {
	trace.debugID = uEventNames::uEventNameServer->next();
	trace.messageNo = 0;
	trace.threads = nativeThread ? 1 : 0;
	trace.nativeThread = nativeThread;
	uCollector::uCollectorServer->uEventNoPartnerNamed( trace, nativeThread ? __DBG_TASK_CREATE__ : __DBG_CREATE__, name, addr );
    } // if
} // uTraceConstructor::uTraceConstructor

uTraceDestructor::uTraceDestructor( int action, uTrace &trace ) {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    if ( action ) {
	uCollector::uCollectorServer->uEventNoPartner( trace, __DBG_DESTROY__ ); // send out a destruction message
    } // if
} // uTraceDestructor::uTraceDestructor

uTraceAcceptStart::uTraceAcceptStart( uTrace &trace ) {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    uCollector::uCollectorServer->uEventNoPartner( trace, __DBG_THREAD_BLOCK__ );
} // uTraceAcceptStart::uTraceAcceptStart

uTraceAcceptDone::uTraceAcceptDone( uTrace &trace ) {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    uCollector::uCollectorServer->uEventNoPartnerNamed( trace, __DBG_THREAD_READY__, uThisTask().uGetName(), &uThisTask() );
} // uTraceAcceptDone::uTraceAcceptDone

uTraceResume::uTraceResume( uTrace &t, const char *rtnName ) : trace( t ) {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    if ( &trace != uThisTask().uTraceInstance ) {	// ignore resume to oneself
	trace.resumer = uThisTask().uTraceInstance;	// store resumer
	int oldMsgNr = trace.resumer->messageNo;	// copy because event number incremented in send
	uCollector::uCollectorServer->uEventNoPartnerNamed( *trace.resumer, __DBG_THREAD_ENTER__, rtnName, 0 );
	uCollector::uCollectorServer->uEvent( trace, __DBG_THREAD_RECEIVED__, trace.resumer->debugID, oldMsgNr );
	uThisTask().uTraceInstance = &trace;
    } // if
} // uTraceResume::uTraceResume

uTraceSuspend::uTraceSuspend( uTrace &trace, const char *rtnName ) {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    int traceMsgNr = uThisTask().uTraceInstance->messageNo; // copy because event number incremented in send
    uCollector::uCollectorServer->uEventNoPartnerNamed( trace, __DBG_THREAD_LEAVE_NT__, rtnName, 0 );
    uCollector::uCollectorServer->uEvent( *trace.resumer, __DBG_THREAD_CONT_NT__, trace.debugID, traceMsgNr );
    uThisTask().uTraceInstance = trace.resumer;
} // uTraceSuspend::uTraceSuspend

uTraceEntry::uTraceEntry( uTrace &t, const char *rtnName ) : trace( t ), old( *uThisTask().uTraceInstance ), rtnName( rtnName ) {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    if ( &trace != uThisTask().uTraceInstance ) {	// ignore recursive call to oneself
	trace.threads += 1;
	int oldMsgNr = old.messageNo;			// copy because event number incremented in send
	uCollector::uCollectorServer->uEventNoPartnerNamed( old, __DBG_THREAD_ENTER__, rtnName, 0 );
	uCollector::uCollectorServer->uEvent( trace, __DBG_THREAD_RECEIVED__, old.debugID, oldMsgNr );
	uThisTask().uTraceInstance = &trace;		// replace with new
    } // if
} // uTraceEntry::uTraceEntry

uTraceEntry::~uTraceEntry() {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    if ( &trace != &old ) {				// ignore recursive call to oneself
	trace.threads -= 1;
	int traceMsgNr = trace.messageNo;		// copy because event number incremented in send
	if ( trace.threads ) {				// object has internal threads => dash trace line
	    uCollector::uCollectorServer->uEventNoPartnerNamed( trace, __DBG_THREAD_LEAVE_T__, rtnName, 0 );
	    uCollector::uCollectorServer->uEvent( old, __DBG_THREAD_CONT_T__, trace.debugID, traceMsgNr );
	} else {					// object has no internal threads => blank trace line
	    uCollector::uCollectorServer->uEventNoPartnerNamed( trace, __DBG_THREAD_LEAVE_NT__, rtnName, 0 );
	    uCollector::uCollectorServer->uEvent( old, __DBG_THREAD_CONT_NT__, trace.debugID, traceMsgNr );
	} // if
	uThisTask().uTraceInstance = &old;
    } // if
} // uTraceEntry::~uTraceEntry

uTracePetition::uTracePetition() {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    uCollector::uCollectorServer->uEventNoPartner( *uThisTask().uTraceInstance, __DBG_MUTEX_PETITION__ ); // send out a petition message
} // uTracePetition::uTracePetition

uTraceMain::uTraceMain( uTrace &t ) : trace( t ) {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    if ( trace.nativeThread ) {
	uCollector::uCollectorServer->uEventNoPartner( trace, __DBG_THREAD_START__ ); // task start message
    } else {
	first = trace.resumer;				// pointer to starter object's trace variable
    } // if
    uThisTask().uTraceInstance = &trace;
} // uTraceMain::uTraceMain

uTraceMain::~uTraceMain() {
  if ( uCollector::uCollectorServer == (uCollector *)0 ) return;
    if ( trace.nativeThread ) {
	uCollector::uCollectorServer->uEventNoPartner( trace, __DBG_THREAD_STOP__ ); // task stop message
    } else {						// coroutine implicit suspend
	int traceMsgNr = trace.messageNo;		// copy because event number incremented in send
	uCollector::uCollectorServer->uEventNoPartnerNamed( trace, __DBG_THREAD_LEAVE_NT__, "main", 0 );
	uCollector::uCollectorServer->uEvent( *first, __DBG_THREAD_CONT_NT__, trace.debugID, traceMsgNr );
	uThisTask().uTraceInstance = first;
    } // if
} // uTraceMain::~uTraceMain


// Local Variables: //
// compile-command: "dmake" //
// End: //
