//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Robert Denda 1997
// 
// uTaskProfileInfo.h -- 
// 
// Author           : Robert Denda
// Created On       : Tue Mar 11 15:35:41 1997
// Last Modified By : Robert Denda
// Last Modified On : Tue Aug 19 18:11:04 1997
// Update Count     : 24
// 


#ifndef __U_TASKPROFILEINFO_H__
#define __U_TASKPROFILEINFO_H__

#include <uC++.h>

class uHashTable;
class uSymbolTable;

class uTaskProfileInfo : public uSeqable {
    friend uTask uProfiler;
    friend class uSPAnalyze;
    friend class uSPClusterAnalyze;
    friend struct uSPTaskArrayEntry;
    friend class uAnalyzeFuncCallTable;
    
    char            *clusterName;                                  // name of cluster
    unsigned int    clusterID;                                     // ID of cluster 
    const char      *name;				   // name of the sampled Task
    const uBaseTask *ID;                                           // ID of the Task
    uHashTable      *TotalRunningTimeTable;                        // table contains total time spent inside the functions in running state
    uHashTable      *TotalBlockedTimeTable;                        // table contains total time spent inside the functions in blocked state
    uHashTable      *TotalReadyTimeTable;                          // table contains total time spent inside the functions in ready state
    uHashTableEntry *TableEntry;                                   // pointer to a hash table entry
    const uSymbolTable *symbolTable;                                  // pointer to the symbol Table of the profiled file
    unsigned int    currFuncID;                                    // temp variable storing the current function ID
    unsigned long   TotalInactiveTime;                             // counts time profiling is inactivated
      
  public:

    uTaskProfileInfo( const uCluster *cluster, const uSymbolTable *symbolTable, const uBaseTask *ID );// constructor
    uTaskProfileInfo();                                            // constructor
    ~uTaskProfileInfo();                                           // destructor
    void add( uBaseTask::uTaskState currState, unsigned int FuncID, bool profileActive, unsigned int times = 1 );   // add sampled call graph information 
    void registerName( const char *n );
    const char *GetName() const { return name; }
    const uBaseTask *GetID() const { return ID; }
    char *GetClusterName() const { return clusterName; }
    unsigned int GetClusterID() const { return clusterID; }
    unsigned long GetTotalInactiveTime() const { return TotalInactiveTime; }
    
    // SP profiling 
    unsigned long GetTotalRunningTime();
    unsigned long GetTotalBlockedTime();
    unsigned long GetTotalReadyTime();
    uHashTable *GetTotalRunningTimeTable() const { return TotalRunningTimeTable; }
    uHashTable *GetTotalReadyTimeTable() const { return TotalReadyTimeTable; }
    uHashTable *GetTotalBlockedTimeTable() const { return TotalBlockedTimeTable; }    
    
}; // uTaskProfileInfo

#endif __U_TASKPROFILEINFO_H__
