//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Robert Denda 1997
// 
// uSymbolTable.h -- 
// 
// Author           : Robert Denda
// Created On       : Tue Jul  9 23:30:31 1996
// Last Modified By : Robert Denda
// Last Modified On : Thu Aug 28 12:13:54 1997
// Update Count     : 72
// 


#ifndef __U_SYMBOLTABLE_H__
#define __U_SYMBOLTABLE_H__
extern "C" {
#include "bfd.h"
}

int uInternalSymbolTableEntryCompare( const void *, const void * ); // function needed for sorting the internal table

struct uSymbolTableEntry {

    char *name;
    unsigned int address;
    char *lineNumberInfo;
    bool object;					// true if demangled symbol name contains ::
    
    uSymbolTableEntry( const char *name, unsigned int address );   // creates a symbol table entry
    ~uSymbolTableEntry();                                          // destructor
    void addLineNumberInfo( char *lineNumberInfo );
}; // uSymbolTableEntry


class uSymbolTable {

    uSymbolTableEntry **Table;                                     // symbol table
    asymbol **InternalTable;                                       // internal symbol table
    long SymbolNum;                                                // number of symbols
    long InternalSymbolNum;                                        // number of internal symbols
    bfd *abfd;
    const long SearchLessOrEqual( unsigned int address ) const;    // returns the index in Table containing the symbol of the function that
							           // contains address
    const long SearchInternalLessOrEqual( unsigned int address ) const;  // returns the index in InternalTable containing the symbol of the function that
							           // contains address
    void GetInternalAddress( unsigned int address, bfd_vma &offset, asection * &sec) const;
							// get the offset and section number 
    
  public:
    uSymbolTable( char* filename );                                // constructor, reads symbols from executable
    ~uSymbolTable();                                               // destructor
    char *GetName( unsigned int address ) const;		   // get a symbol name from an address
    const unsigned int GetAddress( unsigned int address ) const;   // get the address of a function by an address inside it
    const unsigned int GetAddress( const char * name ) const;	   // get the address of a function by its name
    char *GetLineNumberInfo( unsigned int address ) const;	   // get line number of a function by address
    char *GetExactLineNumberInfo( unsigned int address ) const;	   // get exact line number of a function by address    
    char *GetFileName( unsigned int address ) const;		   // get source file name of a function by address
    const long GetSymbolNum() const { return SymbolNum; }
    bool IsObject( unsigned int address ) const;	           // returns true iff oaddress is inside an object's member function 
}; // uSymbolTable

#endif __U_SYMBOLTABLE_H__
