//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Robert Denda 1997
// 
// uProfileTaskSplr.h -- 
// 
// Author           : Robert Denda
// Created On       : Sun Mar  2 22:27:54 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Oct 10 22:43:00 1997
// Update Count     : 88
// 


#ifndef __U_PROFILETASKSPLR_H__
#define __U_PROFILETASKSPLR_H__

#include <uC++.h>
#include "uProcessorProfileInfo.h"
#include <stdarg.h>

extern "C" unsigned int uFunctionPrologue( register char*, register unsigned short *, register unsigned short *);
extern "C" void uFunctionEpilogue();
#if defined( __sparc__ )
extern "C" void uMcount();
#else
extern "C" void mcount();
#endif __sparc__


//######################## uProfileTaskSampler #########################

class uProfileTaskSampler : public uSeqable {
    friend uTask uProcessorTask;
    friend uCoroutine uProcessorKernel;
    friend class uProfileMonitorSet;
    friend uTask    uProfiler;
    friend unsigned int uFunctionPrologue(register char*, register unsigned short *, register unsigned short *);
    friend void uFunctionEpilogue();
    friend uBaseTask;					                     // access: inside_uFunctionPrologue
    friend uBaseCoroutine;				                     // access: inside_uFunctionPrologue
    friend uCoroutineConstructor;					     // access: inside_uFunctionPrologue
    friend uTaskConstructor;						     // access: inside_uFunctionPrologue
    friend uSerialConstructor;						     // access: inside_uFunctionPrologue
    friend uCondition;							     // access: inside_uFunctionPrologue                    
    friend void uAbort( const char *fmt, ... );				     // access: uPrintCallStack
    friend class uSigHandlerModule;					     // access: uPrintCallStack
    friend class uExecutionMonitor;					     // access: uFuncID, uProfileStackBegin, uProfileSP
    friend class uTaskSampler;						     // access: uFuncID. uProfileStackBegin. uProfileSP
    friend class uSerial;						     // access: inside_uFunctionPrologue
    friend class uSerialDestructor;					     // access: inside_uFunctionPrologue
    friend class uSerialMember;						     // access: inside_uFunctionPrologue
#ifdef __sparc__    
    friend void uMcount();
#else
    friend void mcount();
#endif
    
    uProfiler                      &profiler;                          // profiling task
    uBaseTask                      &ID;				       // uC++ task to which the sampler is attached

    mutable unsigned int           inside_uFunctionPrologue;	       // flag needed to indicate recursive calls of uFunctionPrologue
    unsigned int                   uParentFuncID;		       // contains a PC value inside the currently executed function's parent
    unsigned int                   uFuncID;			       // contains a PC value inside the currently executed function
    unsigned int                   firstArgument;		       // contains the value of the first function parameter's argument
    unsigned int                   *uProfileStackBegin;		       // profile stack begin
    unsigned int                   *uProfileSP;			       // profile stack pointer
    char                           *taskName;			       // name of the task

  protected:
    int                            inactive;                                 // if a sampler is inactivated it does not sample data
  public:
    uProfileTaskSampler( uProfiler &profiler, uBaseTask &ID );
    ~uProfileTaskSampler();

    void registerTaskName( const char name[] );		           // register the name of the task 
    void inactivate();                                             // inactivates the sampler
    void activate();                                               // activates the sampler
    void printCallStack( const char * const format, va_list args ) const;   // print the current call stack
    void printCallStackToBuffer( char * const buf, unsigned int const bufsize, const char * const format, va_list args ) const; // print the current call stack into buffer

    // function pointers
    static void (* uProfileTaskSampler_printCallStack)(uProfileTaskSampler *, const char * const format, va_list args );
    static void (* uProfileTaskSampler_printCallStackToBuffer)(uProfileTaskSampler *, char * const buf, unsigned int const bufsize, const char * const format, va_list args );
}; // uProfileTaskSampler

#endif __U_PROFILETASKSPLR_H__
