//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Robert Denda 1997
// 
// uProcessorProfileInfo.h -- 
// 
// Author           : Robert Denda
// Created On       : Fri Mar 28 11:36:20 1997
// Last Modified By : Robert Denda
// Last Modified On : Fri Aug 15 16:08:53 1997
// Update Count     : 55
// 

#ifndef __U_PROCESSORPROFILEINFO_H__
#define __U_PROCESSORPROFILEINFO_H__

#include <uC++.h>

struct uResourceUsage {					// information provided by the operating system.  if not supported, respective member will be NULL

    // time section
    uDuration      *userTime;				// time spent in user mode
    uDuration      *systemTime;				// time spent in system mode
    uDuration      *realTime;				// elapsed time
    uTime          *creationTime;			// creation time stamp
    uTime          *terminationTime;			// termination time stamp
    uDuration      *systemCallTime;			// system call CPU time
    uDuration      *trapTime;				// system trap CPU time
    uDuration      *textPageFaultTime;			// text page fault sleep time
    uDuration      *dataPageFaultTime;			// data page fault sleep time
    uDuration      *kernelPageFaultTime;		// kernel page fault sleep time
    uDuration      *otherSleepTime;			// all other sleep time
    uDuration      *waitCPUTime;			// cpu latency time
    uDuration      *stoppedTime;			// stopped time

    // memory section

    unsigned long  *maxResidentSetSize;			// maximum resident set size in bytes    
    unsigned long  *IOPageFaults;			// number of page faults due to IO Operations
    unsigned long  *noIOPageFaults;			// number of page faults not due to IO Operations
    unsigned long  *swaps;				// number of swaps

    // context switch section

    unsigned long  *voluntaryContextSwitches;		// number of voluntary context switches
    unsigned long  *involuntaryContextSwitches;		// number of involuntary context switches
    unsigned long  *signals;				// number of signals received
    unsigned long  *systemCalls;			// number of system calls

    // file system section

    unsigned long  *readOperations;			// number of read operations
    unsigned long  *writeOperations;			// number of write operations

    // network section

    unsigned long  *messagesSent;			// number of messages sent
    unsigned long  *messagesReceived;			// number of messages received

}; // uResourceUsage



class uProcessorProfileInfo : public uSeqable {
    friend uTask uProfiler;
    friend class uRUAnalyze;
    friend struct uRUProcessorArrayEntry;
    friend class uProfileTaskSampler;			// access cluster, processor
    
    const uCluster      *cluster;       		// cluster 
    const uProcessor    *processor;			// processor

    struct uResourceUsage ResourceUsage; 	        // rusage information
    static struct uResourceUsage *StartUpSystemProcessorResourceUsage; // rusage information of start up period on system processor
    static struct uResourceUsage *StartUpUserProcessorResourceUsage;   // rusage information of start up period on user processor
    
  public:

    uProcessorProfileInfo( const uCluster * const cluster, const uProcessor * const processor ); // constructor
    ~uProcessorProfileInfo();                                           // destructor
    void addRUsage();
    static void initialize();
    struct uResourceUsage *getRUsage() { return &ResourceUsage; }
    const uProcessor *GetProcessor() const { return processor; }
    const uCluster *GetCluster() const { return cluster; }

    
}; // uProcessorProfileInfo

#endif __U_PROCESSORPROFILEINFO_H__
