//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Robert Denda 1997
// 
// uExecutionMonitor.h -- 
// 
// Author           : Robert Denda
// Created On       : Tue Jul 29 17:14:51 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Oct 17 10:16:58 1997
// Update Count     : 72
// 

#ifndef __U_EXECUTIONMONITOR__
#define __U_EXECUTIONMONITOR__

#include <uC++.h>
#include <uCalendar.h>
#include <uCollection.h>
#include "uProfileTaskSplr.h"

uTask uProfiler;					// forward declaration
class uMetricAnalyze;					// forward declaration


class uExecutionMonitor {

  protected:
    const uProfiler &profiler;

    unsigned int GetCurrentFuncID( const uBaseTask &task ) const {
	return task.uProfileTaskSamplerInstance->uFuncID;
    } // uExecutionMonitor::GetCurrentFuncID

    unsigned int GetCurrentParentFuncID( const uBaseTask &task ) const {
	return task.uProfileTaskSamplerInstance->uParentFuncID;
    } // uExecutionMonitor::GetCurrentParentFuncID

    unsigned int GetFirstArgument( const uBaseTask &task ) const {
	return task.uProfileTaskSamplerInstance->firstArgument;
    } // uExecutionMonitor::GetFirstArgument

    unsigned int *GetCurrentProfileStackBegin( const uBaseTask &task ) const {
	return task.uProfileTaskSamplerInstance->uProfileStackBegin;
    } // uExecutionMonitor::GetCurrentProfileStackBegin

    unsigned int *GetCurrentProfileStackPointer( const uBaseTask &task ) const {
	return task.uProfileTaskSamplerInstance->uProfileSP;
    } // uExecutionMonitor::GetCurrentProfileStackPointer

    bool IsProfilingActive( const uBaseTask &task ) const {
	return task.uProfileActive;
    } // uExecutionMonitor::IsProfilingActive

    const char *GetName( const uBaseTask &task ) const {
	return task.uGetName();
    } // uExecutionMonitor::GetName
    
  public:
    uExecutionMonitor( const uProfiler &profiler );

    virtual ~uExecutionMonitor() {
    } // uExecutionMonitor::~uExecutionMonitor

    void initialize();					// should be called from derived class's constructor
    virtual uMetricAnalyze &CreateMetricAnalyze() { return *(uMetricAnalyze *)0; }

    virtual const uProfiler &GetProfiler() const { return profiler; }
    
    virtual void RegisterTaskNotify( const uBaseTask & ){}
    virtual void DeregisterTaskNotify( const uBaseTask & ){}
    virtual void MigrateTaskNotify( const uBaseTask &, const uCluster &, const uCluster & ){}
    virtual void RegisterProcessorNotify( const uProcessor &){}
    virtual void DeregisterProcessorNotify( const uProcessor &){}
    virtual void MigrateProcessorNotify( const uProcessor &, const uCluster &, const uCluster & ){}
    virtual void RegisterFunctionEntryNotify( const uBaseTask &, const unsigned int , const unsigned int, const unsigned int ){}
    virtual void RegisterFunctionExitNotify( const uBaseTask & ) {}
    virtual void RegisterMutexFunctionEntryTryNotify( const uBaseTask &, const uSerial & ) {}
    virtual void RegisterMutexFunctionEntryDoneNotify( const uBaseTask &, const uSerial & ) {}    
    virtual void RegisterMutexFunctionExitNotify( const uBaseTask &, const uSerial & ) {}
    virtual void RegisterMonitorNotify( const uBaseTask &, const uSerial & ) {}
    virtual void DeregisterMonitorNotify( const uBaseTask &, const uSerial & ) {}
    virtual void RegisterAcceptStartNotify( const uBaseTask &, const uSerial & ) {}
    virtual void RegisterAcceptEndNotify( const uBaseTask &, const uSerial & ) {}
    virtual void RegisterSuspendNotify( const uBaseTask &, const uBaseCoroutine & ) {}
    virtual void RegisterResumeNotify( const uBaseTask &, const uBaseCoroutine & ) {}
    virtual void RegisterSignalNotify( const uBaseTask &, const uCondition & ) {}
    virtual void RegisterWaitNotify( const uBaseTask &, const uCondition & ) {}    
    virtual void RegisterCoroutineNotify( const uBaseCoroutine & ){}
    virtual void DeregisterCoroutineNotify( const uBaseCoroutine & ){}
    
    virtual void Poll( unsigned int ){}
    virtual void SetPollFrequency( unsigned int freq ) { pollFrequency = uDuration( 0, freq * 1000000 ); }
    uDuration pollFrequency;
}; // uExecutionMonitor


class uExecutionMonitorNode : public uSeqable {
    uExecutionMonitor &monitor;
    
  public:
    uExecutionMonitorNode( uExecutionMonitor &monitor ) : monitor( monitor ) {
    } // uExecutionMonitorNode::uExecutionMonitorNode

    ~uExecutionMonitorNode() {
	monitor.~uExecutionMonitor();
    } // uExecutionMonitorNode::~uExecutionMonitorNode

    operator uExecutionMonitor() {
	return monitor;
    } // uExecutionMonitorNode::operator uExecutionMonitor

    uExecutionMonitor *operator->() {
	return &monitor;
    } // uExecutionMonitorNode::operator->
}; // uExecutionMonitorNode


#endif __U_EXECUTIONMONITOR__
