//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uSocket.h -- Nonblocking UNIX Socket I/O
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 17:04:36 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 23 16:23:33 1999
// Update Count     : 207
// 


#ifndef __U_SOCKET_H__
#define __U_SOCKET_H__


//#include <uDebug.h>
#include <uFile.h>
#include <uNetwork.h>


#pragma __U_NOT_USER_CODE__


#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdio.h>					// FILENAME_MAX
#include <netdb.h>					// MAXHOSTNAMELEN on Solaris

#ifndef FILENAME_MAX
#define FILENAME_MAX 1024
#endif


//######################### uSocket #########################


class uSocket {
    friend class uSocketServer;				// access: access, locn, uSocket, ~uSocket
    friend class uSocketAccept;				// access: access, locn
    friend class uSocketClient;				// access: access, locn, uSocket, ~uSocket

    uIOlocn locn;
    uIOaccess access;

    const int domain, type, protocol;			// copies for information purposes

    uSocket( uSocket & );				// no copy
    uSocket &operator=( uSocket & );			// no assignment

    void uCreateSocket( int domain, int type, int protocol );
    uSocket( int domain, int type, int protocol );	// creation restricted to friends
    uSocket( uIOCluster &cluster, int domain, int type, int protocol ); // creation restricted to friends
    virtual ~uSocket();
  public:
    uDualEvent uFailure;
    friend uDualEvent uFailure;				// access: access
    uDualEvent uOpenFailure;
    uDualEvent uCloseFailure;
    friend uDualEvent uCloseFailure;			// access: access
}; // uSocket


//######################### uSocketIO #########################


class uSocketIO : public uFileIO {
    uMutex int me_send( char *buf, int len, int flags );
    uMutex int me_sendto( char *buf, int len, int flags, void *to, int tolen );
    uMutex int me_sendmsg( const msghdr *msg, int flags );
    uMutex int me_recv( char *buf, int len, int flags );
    uMutex int me_recvfrom( char *buf, int len, int flags, void *from, int *fromlen );
    uMutex int me_recvmsg( msghdr *msg, int flags );
  protected:
    sockaddr *saddr;
    int saddrlen;

    uSocketIO( uIOlocn &io, uIOaccess &acc, sockaddr *saddr, int saddrlen );
  public:
    uMutex int getsockname( sockaddr *name, int *len );
    uMutex int getpeername( sockaddr *name, int *len );
    int send( char *buf, int len, int flags = 0, uDuration *timeout = NULL );
    int sendto( char *buf, int len, int flags = 0, uDuration *timeout = NULL );
    int sendto( char *buf, int len, void *to, int tolen, int flags = 0, uDuration *timeout = NULL );
    int sendmsg( const msghdr *msg, int flags = 0, uDuration *timeout = NULL );
    int recv( char *buf, int len, int flags = 0, uDuration *timeout = NULL );
    int recvfrom( char *buf, int len, int flags = 0, uDuration *timeout = NULL );
    int recvfrom( char *buf, int len, void *from, int *fromlen, int flags = 0, uDuration *timeout = NULL );
    int recvmsg( msghdr *msg, int flags = 0, uDuration *timeout = NULL );
}; // uSocketIO


//######################### uSocketServer #########################


uMonitor uSocketServer : public uSocketIO {
    friend class uSocketAccept;				// access: socket, me_accept, acceptor, unacceptor, ~uSocketAccept

    int acceptorCnt;
    uSocket socket;					// one-to-one correspondance between server and socket

    uMutex void acceptor();
    uMutex void unacceptor();
    uMutex int me_accept( void *adr, int *len );
    void uCreateSocketServer1( const char *name, int type, int protocol, int backlog );
    void uCreateSocketServer2( unsigned short port, int type, int protocol, int backlog );
    void uCreateSocketServer3( unsigned short *port, int type, int protocol, int backlog );
  public:
    // AF_UNIX
    uSocketServer( const char *name, int type = SOCK_STREAM, int protocol = 0, int backlog = 10 );
    uSocketServer( const char *name, uIOCluster &cluster, int type = SOCK_STREAM, int protocol = 0, int backlog = 10 );
    // AF_INET, local host
    uSocketServer( unsigned short port, int type = SOCK_STREAM, int protocol = 0, int backlog = 10 );
    uSocketServer( unsigned short port, uIOCluster &cluster, int type = SOCK_STREAM, int protocol = 0, int backlog = 10 );
    uSocketServer( unsigned short *port, int type = SOCK_STREAM, int protocol = 0, int backlog = 10 );
    uSocketServer( unsigned short *port, uIOCluster &cluster, int type = SOCK_STREAM, int protocol = 0, int backlog = 10 );
    virtual ~uSocketServer();

    uDualEvent uFailure;
    friend uDualEvent uFailure;				// access: socket
    uDualEvent uOpenFailure;
    uDualEvent uCloseFailure;
    uDualEvent uReadFailure;
    uDualEvent uReadTimeout;
    uDualEvent uWriteFailure;
    uDualEvent uWriteTimeout;
}; // uSocketServer


//######################### uSocketAccept #########################


class uSocketAccept : public uSocketIO {		// monitor
    uSocketServer &socketserver;			// many-to-one correspondence among acceptors and server
    uIOaccess access;

    const uSocket &sock() const;
    void uCreateSocketAcceptor( uDuration *timeout, void *adr, int *len );
  public:
    uSocketAccept( uSocketServer &s, void *adr = NULL, int *len = NULL );
    uSocketAccept( uSocketServer &s, uDuration *timeout, void *adr = NULL, int *len = NULL );
    virtual ~uSocketAccept();

    uDualEvent uFailure;
    friend uDualEvent uFailure;
    uDualEvent uOpenFailure;
    uDualEvent uOpenTimeout;
    uDualEvent uCloseFailure;
    uDualEvent uReadFailure;
    uDualEvent uReadTimeout;
    uDualEvent uWriteFailure;
    uDualEvent uWriteTimeout;
}; // uSocketAccept


//######################### uSocketClient #########################


class uSocketClient : public uSocketIO {		// monitor
    uSocket socket;					// one-to-one correspondence between client and socket

    void uCreateSocketClient1( const char *name, uDuration *timeout, int type, int protocol );
    void uCreateSocketClient2( unsigned short port, uDuration *timeout, int type, int protocol );
    void uCreateSocketClient3( unsigned short port, const char *name, uDuration *timeout, int type, int protocol );
  public:
    // AF_UNIX
    uSocketClient( const char *name, int type = SOCK_STREAM, int protocol = 0 );
    uSocketClient( const char *name, uDuration *timeout, int type = SOCK_STREAM, int protocol = 0 );
    uSocketClient( const char *name, uIOCluster &cluster, int type = SOCK_STREAM, int protocol = 0 );
    uSocketClient( const char *name, uIOCluster &cluster, uDuration *timeout, int type = SOCK_STREAM, int protocol = 0 );
    // AF_INET, local host
    uSocketClient( unsigned short port, int type = SOCK_STREAM, int protocol = 0 );
    uSocketClient( unsigned short port, uDuration *timeout, int type = SOCK_STREAM, int protocol = 0 );
    uSocketClient( unsigned short port, uIOCluster &cluster, int type = SOCK_STREAM, int protocol = 0 );
    uSocketClient( unsigned short port, uIOCluster &cluster, uDuration *timeout, int type = SOCK_STREAM, int protocol = 0 );
    // AF_INET, other host
    uSocketClient( unsigned short port, const char *name, int type = SOCK_STREAM, int protocol = 0 );
    uSocketClient( unsigned short port, const char *name, uDuration *timeout, int type = SOCK_STREAM, int protocol = 0 );
    uSocketClient( unsigned short port, const char *name, uIOCluster &cluster, int type = SOCK_STREAM, int protocol = 0 );
    uSocketClient( unsigned short port, const char *name, uIOCluster &cluster, uDuration *timeout, int type = SOCK_STREAM, int protocol = 0 );
    virtual ~uSocketClient();

    uDualEvent uFailure;
    friend uDualEvent uFailure;
    uDualEvent uOpenFailure;
    uDualEvent uOpenTimeout;
    uDualEvent uCloseFailure;
    uDualEvent uReadFailure;
    uDualEvent uReadTimeout;
    uDualEvent uWriteFailure;
    uDualEvent uWriteTimeout;
}; // uSocketClient


//######################### uSocket (cont) #########################


uDualEvent uSocket::uFailure : public uIOFailure {
    const uSocket &_socket;
  public:
    uFailure( const uSocket &s, const char *const msg );
    const uSocket &socket() const;
    virtual void uDefaultTerminate() const;
}; // uSocket::uFailure


uDualEvent uSocket::uOpenFailure : public uSocket::uFailure {
  protected:
    const int domain;
    const int type;
    const int protocol;
  public:
    uOpenFailure( const uSocket &socket, const int domain, const int type, const int protocol, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocket::uOpenFailure


uDualEvent uSocket::uCloseFailure : public uSocket::uFailure {
  public:
    uCloseFailure( const uSocket &socket, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocket::uCloseFailure


//######################### uSocketServer (cont) #########################


uDualEvent uSocketServer::uFailure : public uSocket::uFailure {
    const uSocketServer &_server;
  public:
    uFailure( const uSocketServer &s, const char *const msg );
    const uSocketServer &server() const;
    int fileDescriptor() const;
    virtual void uDefaultTerminate() const;
}; // uSocketServer::uFailure


uDualEvent uSocketServer::uOpenFailure : public uSocketServer::uFailure {
  protected:
    const unsigned short port;
    char _name[FILENAME_MAX];
    const int domain;
    const int type;
    const int protocol;
    const int backlog;
  public:
    uOpenFailure( const uSocketServer &server, const unsigned short port, const char *const name, int domain, int type, int protocol, int backlog, const char *const msg );
    const char *const name() const;			// return socket name, or NULL when hostname is used
    virtual void uDefaultTerminate() const;
}; // uSocketServer::uOpenFailure


uDualEvent uSocketServer::uCloseFailure : public uSocketServer::uFailure {
    const int acceptorCnt;
  public:
    uCloseFailure( const uSocketServer &server, const int acceptorCnt, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketServer::uCloseFailure


uDualEvent uSocketServer::uReadFailure : public uSocketServer::uFailure {
  protected:
    const char *buf;
    const int len;
    const int flags;
    const void *from;
    const int *fromlen;
    const uDuration *timeout;
  public:
    uReadFailure( const uSocketServer &sa, const char *buf, const int len, const int flags, const void *from, const int *fromlen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketServer::uReadFailure


uDualEvent uSocketServer::uReadTimeout : public uSocketServer::uReadFailure {
  public:
    uReadTimeout( const uSocketServer &sa, const char *buf, const int len, const int flags, const void *from, const int *fromlen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketServer::uReadTimeout


uDualEvent uSocketServer::uWriteFailure : public uSocketServer::uFailure {
  protected:
    const char *buf;
    const int len;
    const int flags;
    const void *to;
    const int tolen;
    const uDuration *timeout;
  public:
    uWriteFailure( const uSocketServer &sa, const char *buf, const int len, const int flags, const void *to, const int tolen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketServer::uWriteFailure


uDualEvent uSocketServer::uWriteTimeout : public uSocketServer::uWriteFailure {
  public:
    uWriteTimeout( const uSocketServer &sa, const char *buf, const int len, const int flags, const void *to, const int tolen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketServer::uWriteTimeout


//######################### uSocketAccept (cont) #########################


uDualEvent uSocketAccept::uFailure : public uSocket::uFailure {
    const uSocketAccept &_acceptor;
  public:
    uFailure( const uSocketAccept &acceptor, const char *const msg );
    const uSocketAccept &acceptor() const;
    const uSocketServer &server() const;
    int fileDescriptor() const;
    virtual void uDefaultTerminate() const;
}; // uSocketAccept::uFailure


uDualEvent uSocketAccept::uOpenFailure : public uSocketAccept::uFailure {
  protected:
    const uDuration *timeout;
    const void *adr;
    const int *len;
  public:
    uOpenFailure( const uSocketAccept &acceptor, const uDuration *timeout, const void *adr, const int *len, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketAccept::uOpenFailure


uDualEvent uSocketAccept::uOpenTimeout : public uSocketAccept::uOpenFailure {
  public:
    uOpenTimeout( const uSocketAccept &acceptor, const uDuration *timeout, const void *adr, const int *len, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketAccept::uOpenTimeout


uDualEvent uSocketAccept::uCloseFailure : public uSocketAccept::uFailure {
  public:
    uCloseFailure( const uSocketAccept &acceptor, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketAccept::uCloseFailure


uDualEvent uSocketAccept::uReadFailure : public uSocketAccept::uFailure {
  protected:
    const char *buf;
    const int len;
    const int flags;
    const void *from;
    const int *fromlen;
    const uDuration *timeout;
  public:
    uReadFailure( const uSocketAccept &sa, const char *buf, const int len, const int flags, const void *from, const int *fromlen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketAccept::uReadFailure


uDualEvent uSocketAccept::uReadTimeout : public uSocketAccept::uReadFailure {
  public:
    uReadTimeout( const uSocketAccept &sa, const char *buf, const int len, const int flags, const void *from, const int *fromlen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketAccept::uReadTimeout


uDualEvent uSocketAccept::uWriteFailure : public uSocketAccept::uFailure {
  protected:
    const char *buf;
    const int len;
    const int flags;
    const void *to;
    const int tolen;
    const uDuration *timeout;
  public:
    uWriteFailure( const uSocketAccept &sa, const char *buf, const int len, const int flags, const void *to, const int tolen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketAccept::uWriteFailure


uDualEvent uSocketAccept::uWriteTimeout : public uSocketAccept::uWriteFailure {
  public:
    uWriteTimeout( const uSocketAccept &sa, const char *buf, const int len, const int flags, const void *to, const int tolen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketAccept::uWriteTimeout


//######################### uSocketClient (cont) #########################


uDualEvent uSocketClient::uFailure : public uSocket::uFailure {
    const uSocketClient &_client;
  public:
    uFailure( const uSocketClient &client, const char *const msg );
    const uSocketClient &client() const;
    int fileDescriptor() const;
    virtual void uDefaultTerminate() const;
}; // uSocketClient::uFailure


uDualEvent uSocketClient::uOpenFailure : public uSocketClient::uFailure {
  protected:
    unsigned short port;
    char _name[FILENAME_MAX];
    const uIOCluster &cluster;
    const uDuration *timeout;
    const int domain;
    const int type;
    const int protocol;
  public:
    uOpenFailure( const uSocketClient &client, const unsigned short port, const char *const name, const uIOCluster &cluster, uDuration *timeout, const int domain, const int type, const int protocol, const char *const msg );
    const char *const name() const;
    virtual void uDefaultTerminate() const;
}; // uSocketClient::uOpenFailure


uDualEvent uSocketClient::uOpenTimeout : public uSocketClient::uOpenFailure {
  public:
    uOpenTimeout( const uSocketClient &client, const unsigned short port, const char *const name, const uIOCluster &cluster, uDuration *timeout, const int domain, const int type, const int protocol, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketClient::uOpenTimeout


uDualEvent uSocketClient::uCloseFailure : public uSocketClient::uFailure {
  public:
    uCloseFailure( const uSocketClient &acceptor, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketClient::uCloseFailure


uDualEvent uSocketClient::uReadFailure : public uSocketClient::uFailure {
  protected:
    const char *buf;
    const int len;
    const int flags;
    const void *from;
    const int *fromlen;
    const uDuration *timeout;
  public:
    uReadFailure( const uSocketClient &sa, const char *buf, const int len, const int flags, const void *from, const int *fromlen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketClient::uReadFailure


uDualEvent uSocketClient::uReadTimeout : public uSocketClient::uReadFailure {
  public:
    uReadTimeout( const uSocketClient &sa, const char *buf, const int len, const int flags, const void *from, const int *fromlen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketClient::uReadTimeout


uDualEvent uSocketClient::uWriteFailure : public uSocketClient::uFailure {
  protected:
    const char *buf;
    const int len;
    const int flags;
    const void *to;
    const int tolen;
    const uDuration *timeout;
  public:
    uWriteFailure( const uSocketClient &sa, const char *buf, const int len, const int flags, const void *to, const int tolen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketClient::uWriteFailure


uDualEvent uSocketClient::uWriteTimeout : public uSocketClient::uWriteFailure {
  public:
    uWriteTimeout( const uSocketClient &sa, const char *buf, const int len, const int flags, const void *to, const int tolen, const uDuration *timeout, const char *const msg );
    virtual void uDefaultTerminate() const;
}; // uSocketClient::uWriteTimeout


#pragma __U_USER_CODE__

#endif __U_SOCKET_H__


// Local Variables:
// compile-command: "dmake"
// End:
