//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1994
// 
// uSemaphore.h -- simulate counting semaphore with monitor
// 
// Author           : Peter A. Buhr
// Created On       : Tue Mar 29 13:42:33 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Apr 29 08:42:54 1999
// Update Count     : 41
// 


#ifndef __U_SEMAPHORE_H__
#define __U_SEMAPHORE_H__

#pragma __U_NOT_USER_CODE__


uMonitor uSemaphore {
    int cnt;						// semaphore counter
    uCondition blockedTasks;
  public:
    uSemaphore( unsigned int cnt = 1 ) : cnt( cnt ) {
    } // uSemaphore::uSemaphore

    void uV( unsigned int times = 1 ) {			// signal a semaphore
	cnt += times;					// increment semaphore counter
	for ( int i = 0; i < times; i += 1 ) {		// wake up required number of tasks
	    uSignal blockedTasks;
	} // for
    } // uSemaphore::uV

    void uP() {						// wait on a semaphore
	cnt -= 1;					// decrement semaphore counter
	if ( cnt < 0 ) uWait blockedTasks;		// if semaphore less than zero, wait for next V
    } // uSemaphore::uP

    // This routine forces the implementation to use internal scheduling,
    // otherwise there is a deadlock problem with accepting V in the previous P
    // routine, which prevents calls entering this routine to V the parameter
    // and wait.  Essentially, it is necessary to enter the monitor and do some
    // work *before* possibly blocking. To use external scheduling requires
    // accepting either the V routine OR this P routine, which is currently
    // impossible because there is not differentiation between overloaded
    // routines. I'm not sure the external scheduling solution would be any
    // more efficient than the internal scheduling solution.

    void uP( uSemaphore &s ) {				// wait on a semaphore and release another
	s.uV();						// release other semaphore
	uP();						// wait
    } // uSemaphore::uP

    uNoMutex bool uEmpty() const {			// no tasks waiting on semaphore ?
	return cnt >= 0;
    } // uSemaphore::uEmpty
}; // uSemaphore


#pragma __U_USER_CODE__

#endif __U_SEMAPHORE_H__


// Local Variables:
// compile-command: "dmake"
// End:
