//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uPoll.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 17:01:20 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jun  3 10:39:58 1996
// Update Count     : 8
// 


#ifndef __POLL_H__
#define __POLL_H__

#pragma __U_NOT_USER_CODE__


#if defined( __svr4__ )

#define U_FNDELAY O_NONBLOCK				// POSIX non-blocking
#define U_EWOULDBLOCK EAGAIN

#elif defined( __ibm__ )

#define U_FNDELAY FNONBLOCK				// POSIX non-blocking
#define U_EWOULDBLOCK EWOULDBLOCK

#elif defined( __hp__ )

#define U_FNDELAY O_NONBLOCK				// POSIX non-blocking
#define U_EWOULDBLOCK EAGAIN

#elif defined( __dec__ )				// dec/ultrix

#define U_FNDELAY FNDELAY				// TEMPORARY: O_NONBLOCK does not work with sockets
#define U_EWOULDBLOCK EWOULDBLOCK || errno == EAGAIN

#else

#define U_FNDELAY FNDELAY
#define U_EWOULDBLOCK EWOULDBLOCK

#endif

enum uPollStatus {
    uNeverPoll,
    uPollOnDemand,
    uAlwaysPoll,
};

class uPoll {
  private:
    uPollStatus uStatus;
  public:
    uPollStatus uGetStatus();
    void uComputeStatus( int fd );
    void uSetStatus( uPollStatus status );
    void uSetPollFlag( int fd );
    void uClearPollFlag( int fd );
};


#pragma __U_USER_CODE__

#endif __POLL_H__


// Local Variables:
// compile-command: "dmake"
// End:
