//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uOwner.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:57:28 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May 22 11:31:58 1999
// Update Count     : 20
// 


#ifndef __U_OWNERLOCK_H__
#define __U_OWNERLOCK_H__

#pragma __U_NOT_USER_CODE__


uMonitor uOwnerLock {
    uBaseTask *uOwnerId;
    int uCount;
    uCondition Condition;
  public:
    uOwnerLock() {
	uOwnerId = NULL;				// no one owns the lock
	uCount = 0;					// so count is zero
    } // uOwnerLock::uOwnerLock

    ~uOwnerLock() {
    } // uOwnerLock::~uOwnerLock

    void uAcquire() {
	if ( uOwnerId != &uThisTask() ) {		// don't own lock yet
	    if ( uOwnerId != NULL ) {			// but if someone does
		uWait Condition;			// wait for lock
	    } // if
	    uOwnerId = &uThisTask();			// acquire the lock
	} // if
	uCount += 1;					// remember how often
    } // uOwnerLock::uAcquire

    bool uTryAcquire() {
	if ( uOwnerId != &uThisTask() ) {		// don't own lock yet
	    if ( uOwnerId != NULL ) {			// but if someone does
		return false;				// don't wait for the lock
	    } // if
	    uOwnerId = &uThisTask();			// acquire the lock
	} // if
	uCount += 1;					// remember how often
	return true;
    } // uOwnerLock::uTryAcquire

    void uRelease() {
#ifdef __U_DEBUG__
	if ( uOwnerId != &uThisTask() ) {
	    uAbort( "(uOwnerLock &)0x%p.uRelease(): attempt to release owner lock, which is currently owned by task 0x%p (%.256s).",
		    this, uOwnerId, uOwnerId->uGetName() );
	} // if
#endif __U_DEBUG__
	uCount -= 1;					// release the lock
	if ( uCount == 0 ) {				// if this is the last
	    uOwnerId = NULL;				// release, nobody owns
	    uSignal Condition;				// lock, wake someone
	} // if
    } // uOwnerLock::uRelease
}; // uOwnerLock


#pragma __U_USER_CODE__

#endif __U_OWNERLOCK_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
