//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uOStream.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:55:15 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 23 14:09:07 1999
// Update Count     : 34
// 


#ifndef __U_OSTREAM_H__
#define __U_OSTREAM_H__


#include <uFilebuf.h>
#include <uIos.h>

#pragma __U_NOT_USER_CODE__

#if __GNUG__ == 2					// GNU 2.x header
#include <ostream.h>
#else
#include <iostream.h>
#endif // __GNUG__ == 2


class uOStream;						// forward

uOStream &endl( uOStream &os );
uOStream &ends( uOStream &os );
uOStream &flush( uOStream &os );

uOStream &dec( uOStream &os );
uOStream &hex( uOStream &os );
uOStream &oct( uOStream &os );

uOStream &uAcquire( uOStream &os );
uOStream &uRelease( uOStream &os );

class uOStream : public uIos {
    friend uOStream &endl( uOStream &os );
    friend uOStream &ends( uOStream &os );
    friend uOStream &flush( uOStream &os );
    friend uOStream &dec( uOStream &os );
    friend uOStream &hex( uOStream &os );
    friend uOStream &oct( uOStream &os );
    friend uOStream &uAcquire( uOStream &os );
    friend uOStream &uRelease( uOStream &os );

    uOStream( uOStream & );				// no copy
    uOStream &operator=( uOStream & );			// no assignment
  private:
    // Could not use public inheritance because of mutual exclusion problems
    // and cascading (contra-variance).

    ostream ofile;
  protected:
    int deletebuf;					// should the buffer be deleted on termination ?
  public:
    uOStream();
    uOStream( streambuf *buf );
    ~uOStream();

    int opfx();
    void osfx();
    uOStream &flush();
    uOStream &put( char c );
    uOStream &write( const char *s, int n );
    uOStream &write( const unsigned char *s, int n );
    uOStream &write( const signed char *s, int n );
    uOStream &write( const void *s, int n );
    uOStream &seekp( streampos );
    streampos tellp();
    uOStream &operator << ( char c );
    uOStream &operator << ( unsigned char c );
    uOStream &operator << ( signed char c);
    uOStream &operator << ( const char *s );
    uOStream &operator << ( const unsigned char *s );
    uOStream &operator << ( const void *p );
    uOStream &operator << ( int n );
    uOStream &operator << ( unsigned int n );
    uOStream &operator << ( long n );
    uOStream &operator << ( unsigned long n );
    uOStream &operator << ( long long n );
    uOStream &operator << ( unsigned long long n );
    uOStream &operator << ( short n );
    uOStream &operator << ( unsigned short n );
    uOStream &operator << ( bool n);
    uOStream &operator << ( double n );
    uOStream &operator << ( float n );
    uOStream &operator << ( long double n );
    uOStream &operator << ( uOStream &( *f )( uOStream & ) );

    ostream &stream();

#if __GNUG__ == 2					// additional GNU 2.x routines
    streambuf *uOStreambuf();
//  uOStream &form( const char *format ... );
//  uOStream &vform( const char *format, _G_va_list args );
#endif // __GNUG__ == 2

}; // uOStream


//######################### uOStreamModule #########################


class uOStreamModule {
  public:
    static uFilebuf *uCoutFilebuf;
    static uOStream *uCoutStream;
    static uFilebuf *uCerrFilebuf;
    static uOStream *uCerrStream;
    static uFilebuf *uClogFilebuf;
    static uOStream *uClogStream;			// buffered errors
}; // uOStreamModule


#define uCout (*uOStreamModule::uCoutStream)
#define uCerr (*uOStreamModule::uCerrStream)
#define uClog (*uOStreamModule::uClogStream)


//######################### uOStream Boot #########################


class uOStreamBoot {
    static int count;

    void startup();
    void finishup();
  public:
    uOStreamBoot() {
	count += 1;
	if ( count == 1 ) {
	    startup();
	} // if
    } // uOStreamBoot::uOStreamBoot

    ~uOStreamBoot() {
	if ( count == 1 ) {
	    finishup();
	} // if
	count -= 1;
    } // uOStreamBoot::uOStreamBoot
}; // uOStreamBoot


// Create an instance in each translation unit, but only the first instance to
// execute performs the system bootstrap. Do not include instances in the
// kernel modules.

#ifndef __U_KERNEL__
static uOStreamBoot uBootuOStream;
#endif __U_KERNEL__


#pragma __U_USER_CODE__

#endif __U_OSTREAM_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
