//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uOStream.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:56:01 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 23 21:25:11 1999
// Update Count     : 83
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uOStream.h>


uOStream &endl( uOStream &os ) {
    uIosWrapper wrapper( os );

    endl( os.ofile );
    return os;
} // endl

uOStream &ends( uOStream &os ) {
    uIosWrapper wrapper( os );

    ends( os.ofile );
    return os;
} // ends

uOStream &flush( uOStream &os ) {
    uIosWrapper wrapper( os );

    flush( os.ofile );
    return os;
} // flush

uOStream &dec( uOStream &os ) {
    uIosWrapper wrapper( os );

    dec( os.ofile );
    return os;
} // dec

uOStream &hex( uOStream &os ) {
    uIosWrapper wrapper( os );

    hex( os.ofile );
    return os;
} // hex

uOStream &oct( uOStream &os ) {
    uIosWrapper wrapper( os );

    oct( os.ofile );
    return os;
} // oct

uOStream &uAcquire( uOStream &os ) {
    os.owner.uAcquire();
    return os;
} // uAcquire

uOStream &uRelease( uOStream &os ) {
    os.owner.uRelease();
    return os;
} // uRelease

uOStream::uOStream() : ofile( new uFilebuf ) {
    iofile = &ofile;
    deletebuf = 1;
} // uOStream::uOStream

uOStream::uOStream( streambuf *buf ) : ofile( buf ) {
    iofile = &ofile;
    deletebuf = 0;
} // uOStream::uOStream

uOStream::~uOStream() {
    uIosWrapper wrapper( *this );

    flush();
    if ( deletebuf ) {
	delete rdbuf();
    } // if
} // uOStream::~uOStream

int uOStream::opfx() {
    uIosWrapper wrapper( *this );

    return ofile.opfx();
} // uOStream::opfx

void uOStream::osfx() {
    uIosWrapper wrapper( *this );

    ofile.osfx();
} // uOStream::osfx

uOStream &uOStream::flush() {
    uIosWrapper wrapper( *this );

    ofile.flush();
    return *this;
} // uOStream::flush

uOStream &uOStream::put( char c ) {
    uIosWrapper wrapper( *this );

    ofile.put( c );
    return *this;
} // uOStream::put

uOStream &uOStream::write( const char *s, int n ) {
    uIosWrapper wrapper( *this );

    ofile.write( s, n );
    return *this;
} // uOStream::write

uOStream &uOStream::write( const unsigned char *s, int n ) {
    uIosWrapper wrapper( *this );

    ofile.write( s, n );
    return *this;
} // uOStream::write

uOStream &uOStream::write( const signed char *s, int n ) {
    uIosWrapper wrapper( *this );

    ofile.write( s, n );
    return *this;
} // uOStream::write

uOStream &uOStream::write( const void *s, int n ) {
    uIosWrapper wrapper( *this );

    ofile.write( s, n );
    return *this;
} // uOStream::write

uOStream &uOStream::seekp( streampos pos ) {
    uIosWrapper wrapper( *this );

    ofile.seekp( pos );
    return *this;
} // uOStream::seekp

streampos uOStream::tellp() {
    uIosWrapper wrapper( *this );

    return tellp();
} // uOStream::tellp

uOStream &uOStream::operator << ( char c ) {
    uIosWrapper wrapper( *this );

    ofile << ( const unsigned char ) c;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( unsigned char c ) {
    uIosWrapper wrapper( *this );

    ofile << c;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( signed char c ) {
    uIosWrapper wrapper( *this );

    ofile << c;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( const char *s ) {
    uIosWrapper wrapper( *this );

    ofile << s;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( const unsigned char *s ) {
    uIosWrapper wrapper( *this );

    ofile << (const char *) s;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( const void *p ) {
    uIosWrapper wrapper( *this );
#if 0
    // The following line is the correct way to perform this routine.  However,
    // the GNU ostream version of this routine calls something called vform,
    // which prints nothing. I don't have the patience to figure out why, so
    // I'm using a work around. Calling vform is *not* the best way to print a
    // pointer in hex, anyway!

    // ofile << p;

    long prev = setf( ios::hex, ios::basefield );	// do it in hex
    *this << (long int)p;				// treat pointer as a long int (works on *real* computers ;-)
    prev = setf( prev, ios::basefield );		// put it back the way it was
#endif
    ofile << p;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( int n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( unsigned int n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( long n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( unsigned long n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( long long n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( unsigned long long n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<
    
uOStream &uOStream::operator << ( short  n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( unsigned short n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( bool n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( double n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( float  n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

#if ! defined( __gizmo__ )				// TEMPORARY, problem with gcc 2.6.2 floating point code generation for m68k
uOStream &uOStream::operator << ( long double n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<
#endif

uOStream &uOStream::operator << ( uOStream &( *f )( uOStream & ) ) {
    return (*f)( *this );
} // uOStream::operator <<

ostream &uOStream::stream() {
    return ofile;
} // uOStream::stream


// additional GNU 2.x routines
#if __GNUG__ == 2

streambuf *uOStream::uOStreambuf() {
    uIosWrapper wrapper( *this );

    return ofile.ostreambuf();
} // uOStream::uOStreambuf

// These cannot be replaced because of the variable number of parameters

// uOStream &form( const char *format ... );
// uOStream &vform( const char *format, _G_va_list args );

#endif __GNUG__ == 2


//######################### uOStreamModule #########################


int uOStreamBoot::count = 0;
uFilebuf *uOStreamModule::uCoutFilebuf = (uFilebuf *)0;
uOStream *uOStreamModule::uCoutStream = (uOStream *)0;
uFilebuf *uOStreamModule::uCerrFilebuf = (uFilebuf *)0;
uOStream *uOStreamModule::uCerrStream = (uOStream *)0;
uFilebuf *uOStreamModule::uClogFilebuf = (uFilebuf *)0;
uOStream *uOStreamModule::uClogStream = (uOStream *)0;


//######################### uOStream Boot #########################


void uOStreamBoot::startup() {
    uOStreamModule::uCoutFilebuf = new uFilebuf( 1, *uKernelModule::uSystemCluster );
    uOStreamModule::uCoutStream  = new uOStream( uOStreamModule::uCoutFilebuf );
    uOStreamModule::uCerrFilebuf = new uFilebuf( 2, *uKernelModule::uSystemCluster, 1 ); // 1 byte buffer
    uOStreamModule::uCerrStream  = new uOStream( uOStreamModule::uCerrFilebuf );
    uOStreamModule::uClogFilebuf = new uFilebuf( 2, *uKernelModule::uSystemCluster );
    uOStreamModule::uClogStream  = new uOStream( uOStreamModule::uClogFilebuf );
} // uOStreamBoot::startup

void uOStreamBoot::finishup() {
    delete uOStreamModule::uClogStream;
    delete uOStreamModule::uClogFilebuf;
    delete uOStreamModule::uCerrStream;
    delete uOStreamModule::uCerrFilebuf;
    delete uOStreamModule::uCoutStream;
    delete uOStreamModule::uCoutFilebuf;
} // uOStreamBoot::finishup


// Local Variables: //
// compile-command: "dmake" //
// End: //
