//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1996
// 
// uNetwork.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Thu Oct 31 13:34:46 1996
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Apr 30 22:37:34 1999
// Update Count     : 32
// 


#define __U_KERNEL__
#include <uC++.h>
//#include <uDebug.h>
#include <uNetwork.h>


#include <unistd.h>


#if defined( __svr4__ ) && defined( __sun__ )
extern "C" int gethostname( char *name, int namelen );	// missing from 
#endif

#if ! defined( __svr4__ ) && defined( __sun__ )
extern "C" int gethostname( char *name, int namelen );	// missing from 
#endif

#if defined( __ultrix__ ) && defined( __dec__ )
extern "C" int gethostname( char *name, int namelen );	// missing from 
#endif


#include <netdb.h>					// MAXHOSTNAMELEN on Solaris

// All timer signals must be turned off because some systems use the time to do
// timeouts on calls to name servers on other machines.

int uGethostname( const char *const name, int len ) {
    uThisProcessor().uEvents->uPauseEvents();		// turn timer off
    int code = gethostname( (char *)name, len );	// get host name for this system
    uThisProcessor().uEvents->uRestartEvents();		// turn timer on
    return code;
} // uGethostname

int uGethostbyname( const char *const name, hostent *h ) {
    uThisProcessor().uEvents->uPauseEvents();		// turn timer off
    hostent *code = gethostbyname( (char *)name );	// get internet address from internet name
    if ( code ) {
	*h = *code;					// copy static data
	code = (hostent *)0;
    } else {
	code = (hostent *)-1;
    } // if
    uThisProcessor().uEvents->uRestartEvents();		// turn timer on
    return (int)code;
} // uGethostbyname


// Local Variables:
// compile-command: "dmake"
// End:
