//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uIos.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:53:37 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 23 21:22:20 1999
// Update Count     : 27
// 


#ifndef __U_IOS_H__
#define __U_IOS_H__

#include <uOwnerLock.h>

#pragma __U_NOT_USER_CODE__

#if __GNUG__ == 2					// GNU 2.x header
#include <streambuf.h>
#else
#include <iostream.h>
#endif // __GNUG__ == 2


class uIos;

class uIosWrapper {
  private:
    uIos &stream;
  public:
    uIosWrapper( uIos &stream );
    ~uIosWrapper();
};

uIos &setbase( uIos &os, int b );
uIos &setfill( uIos &os, int f );
uIos &setprecision( uIos &os, int p );
uIos &setw( uIos &os, int w );
uIos &setiosflags( uIos &os, ios::fmtflags f );
uIos &resetiosflags( uIos &os, ios::fmtflags f );

class uIos {
    friend class uIosWrapper;
    friend uIos &setbase( uIos &os, int b );
    friend uIos &setfill( uIos &os, int f );
    friend uIos &setprecision( uIos &os, int p );
    friend uIos &setw( uIos &os, int w );
    friend uIos &setiosflags( uIos &os, ios::fmtflags f );
    friend uIos &resetiosflags( uIos &os, ios::fmtflags f );

    uIos( uIos & );					// no copy
    uIos &operator=( uIos & );				// no assignment
  protected:
    ios *iofile;					// can't seem to make this a reference
    uOwnerLock owner;

    void uEnter() {
	owner.uAcquire();
    } // uIos::uEnter

    void uLeave() {
	owner.uRelease();
    } // uIos::uLeave
  public:
    uIos() {
    } // uIos::uIos

    // ios routines that do not require cover routines

    int bad() {
	return iofile->bad();
    } // uIos::bad

    int eof() {
	return iofile->eof();
    } // uIos::eof

    int fail() {
	return iofile->fail();
    } // uIos::fail

    char fill() {
	return iofile->fill();
    } // uIos::file

    long flags() {
	return iofile->flags();
    } // uIos::flags

    int good() {
	return iofile->good();
    } // uIos::good

    int operator!() {
	return ! iofile;
    } // uIos::operator!

    operator void*() {
	return iofile;
    } // uIos::operator *

    int precision() {
	return iofile->precision();
    } // uIos::precision

    streambuf *rdbuf() {
	return iofile->rdbuf();
    } // uIos::rebuf

    int rdstate() {
	return iofile->rdstate();
    } // uIos::rdstate

    int width() {
	return iofile->width();
    } // uIos::width

    // ios routines that change state and have to be performed mutually exclusively

    unsigned long flags( unsigned long f ) {
	uIosWrapper wrapper( *this );

	return iofile->flags( f );
    } // uIos::flags

    unsigned long setf( unsigned long f, unsigned long mask ) {
	uIosWrapper wrapper( *this );

	return iofile->setf( f, mask );
    } // uIos::setf

    unsigned long setf( unsigned long f ) {
	uIosWrapper wrapper( *this );

	return iofile->setf( f );
    } // uIos::setf

    unsigned long unsetf( unsigned long mask ) {
	uIosWrapper wrapper( *this );

	return iofile->unsetf( mask );
    } // uIos::unsetf

    int width( int w ) {
	uIosWrapper wrapper( *this );

	return iofile->width( w );
    } // uIos::width

    char fill( char newf ) {
	uIosWrapper wrapper( *this );

	return iofile->fill( newf );
    } // uIos::fill

    unsigned short precision( int newp ) {
	uIosWrapper wrapper( *this );

	return iofile->precision( newp );
    } // uIos::precision

    void clear( int state ) {
	uIosWrapper wrapper( *this );

	iofile->clear( state );
	return;
    } // uIos::clear

// additional GNU 2.x routines
#if __GNUG__ == 2

    void set( int f ) {
	uIosWrapper wrapper( *this );

	iofile->set( f );
    } // uIos::set

    // Crazy: if iostream is included first than _STREAM_COMPAT is not defined,
    // but if ostream is included first _STREAM_COMPAT is defined. Now if
    // ostream is included after iostream, _STREAM_COMPAT is now defined but
    // the classes in iostream have already been conditionally expanded to not
    // have these routines. So I have to know if iostream is defined to know if
    // _STREAM_COMPAT is actually meaningful (give me a break!).

#if ! defined(_IOSTREAM_H) && defined(_STREAM_COMPAT)

    void unset( state_value f ) {
	uIosWrapper wrapper( *this );

	iofile->unset( f );
    } // uIos::unset

    void close() {
	uIosWrapper wrapper( *this );

	iofile->close();
    } // uIos::close

#endif // ! defined(_IOSTREAM_H) && defined(_STREAM_COMPAT)
#endif // __GNUG__ == 2

}; // uIos


#pragma __U_USER_CODE__

#endif __U_IOS_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
