//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uIos.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:54:28 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 23 21:22:49 1999
// Update Count     : 8
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uIos.h>


uIosWrapper::uIosWrapper( uIos &stream ) : stream( stream ) {
    stream.uEnter();
} // uIosWrapper::uIosWrapper

uIosWrapper::~uIosWrapper() {
    stream.uLeave();
} // uIosWrapper::~uIosWrapper

// These manipulators have their addresses taken so they can't be inline.

uIos &setbase( uIos &os, int b ) {
    uIosWrapper wrapper( os );

    os.iofile->setf( b, ios::basefield );
    return os;
} // setbase

uIos &setfill( uIos &os, int f ) {
    uIosWrapper wrapper( os );

    os.iofile->fill( f );
    return os;
} // setfill

uIos &setprecision( uIos &os, int p ) {
    uIosWrapper wrapper( os );

    os.iofile->precision( p );
    return os;
} // setprecision

uIos &setw( uIos &os, int w ) {
    uIosWrapper wrapper( os );

    os.iofile->width( w );
    return os;
} // setw

uIos &setiosflags( uIos &os, ios::fmtflags f ) {
    uIosWrapper wrapper( os );

    os.iofile->setf( f );
    return os;
} // setiosflags

uIos &resetiosflags( uIos &os, ios::fmtflags f ) {
    uIosWrapper wrapper( os );

    os.iofile->setf( 0, f );
    return os;
} // resetiosflags


// Local Variables: //
// compile-command: "dmake" //
// End: //
