//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uIStream.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:51:42 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 23 13:57:18 1999
// Update Count     : 27
// 


#ifndef __U_ISTREAM_H__
#define __U_ISTREAM_H__


#include <uFilebuf.h>
#include <uIos.h>

#pragma __U_NOT_USER_CODE__

#if __GNUG__ == 2					// GNU 2.x header
#include <istream.h>
#else
#include <iostream.h>
#endif // __GNUG__ == 2


class uIStream;						// forward
class uOStream;						// forward

uIStream &ws( uIStream &is );

uIStream &dec( uIStream &is );
uIStream &hex( uIStream &is );
uIStream &oct( uIStream &is );

uIStream &uAcquire( uIStream &is );
uIStream &uRelease( uIStream &is );

class uIStream : public uIos {
    friend uIStream &ws( uIStream &is );
    friend uIStream &dec( uIStream &is );
    friend uIStream &hex( uIStream &is );
    friend uIStream &oct( uIStream &is );
    friend uIStream &uAcquire( uIStream &is );
    friend uIStream &uRelease( uIStream &is );

    uIStream( uIStream & );				// no copy
    uIStream &operator=( uIStream & );			// no assignment
  protected:
    // Could not use public inheritance because of mutual exclusion problems
    // and cascading (contra-variance).

    istream ifile;

    // The concept of "tied" involves 2 files, which causes mutual exclusion
    // problems if the tied-file is not a uOStream. As a result, all aspects of
    // tied had to performed in the derived class and not the base class to
    // ensure that uOStream's routine are called. If member routine flush was
    // virtual, this would not have been necessary.

    uOStream *tied_to;
  protected:
    int deletebuf;					// should the buffer be deleted on termination ?
  public:
    uIStream();
    uIStream( streambuf *buf, uOStream *tied = (uOStream *)0 );
    virtual ~uIStream();

    uIStream &get( char *ptr, int len, char delim = '\n' );
    uIStream &get( unsigned char *ptr, int len, char delim = '\n' );
    uIStream &get( char &c );
    uIStream &get( unsigned char &c );
    uIStream &get( signed char &c );
    uIStream &get( signed char *ptr, int len, char delim = '\n' );
    uIStream &get( streambuf &sb, char delim = '\n' );
    uIStream &gets( char **s, char delim = '\n' );
    uIStream &getline( char *ptr, int len, char delim = '\n' );
    uIStream &getline( unsigned char *ptr, int len, char delim = '\n' );
    uIStream &getline( signed char *ptr, int len, char delim = '\n' );
    uIStream &read( char *ptr, int n );
    uIStream &read( unsigned char *ptr, int n );
    uIStream &read( signed char *ptr, int n );
    uIStream &read( void *ptr, int n );

    int ipfx( int need = 0 );
    int ipfx0();
    int ipfx1();
    int get();
    int peek();
    int gcount();
    uIStream &ignore( int n = 1, int delim = EOF );
    int sync();
    uIStream &seekg( streampos pos );
    uIStream &seekg( streamoff off, ios::seek_dir dir );
    streampos tellg();
    uIStream &putback( char c );
    uIStream &unget();
    uIStream &operator >> ( char *s );
    uIStream &operator >> ( unsigned char *s );
    uIStream &operator >> ( signed char *s );
    uIStream &operator >> ( char &c );
    uIStream &operator >> ( unsigned char &c );
    uIStream &operator >> ( signed char &c );
    uIStream &operator >> ( int &n );
    uIStream &operator >> ( long &n );
    uIStream &operator >> ( long long &n );
    uIStream &operator >> ( unsigned long long &n );
    uIStream &operator >> ( short &n );
    uIStream &operator >> ( unsigned int &n );
    uIStream &operator >> ( unsigned long &n );
    uIStream &operator >> ( unsigned short &n );
    uIStream &operator >> ( bool &n );
    uIStream &operator >> ( float &n );
    uIStream &operator >> ( double &n );
    uIStream &operator >> ( long double &n );
    uIStream &operator >> ( uIStream &( *f )( uIStream & ) );

    uOStream *tie();
    uOStream *tie( uOStream *os );

    istream &stream();

#if __GNUG__ == 2					// additional GNU 2.x routines
#ifdef _STREAM_COMPAT
    uIStream &unget( char ch );
    int skip( int i );
    streambuf *uIStreambuf();
#endif // _STREAM_COMPAT
#endif // __GNUG__ == 2

}; // uIStream


//######################### uIStreamModule #########################


class uIStreamModule {
  public:
    static uFilebuf *uCinFilebuf;
    static uIStream *uCinStream;
}; // uIStreamModule


#define uCin (*uIStreamModule::uCinStream)


//######################### uIStream Boot #########################


class uIStreamBoot {
    static int count;

    void startup();
    void finishup();
  public:
    uIStreamBoot() {
	count += 1;
	if ( count == 1 ) {
	    startup();
	} // if
    } // uIStreamBoot::uIStreamBoot

    ~uIStreamBoot() {
	if ( count == 1 ) {
	    finishup();
	} // if
	count -= 1;
    } // uIStreamBoot::uIStreamBoot
}; // uIStreamBoot


// Create an instance in each translation unit, but only the first instance to
// execute performs the system bootstrap. Do not include instances in the
// kernel modules.

#ifndef __U_KERNEL__
static uIStreamBoot uBootuIStream;
#endif __U_KERNEL__


#pragma __U_USER_CODE__

#endif __U_ISTREAM_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
