//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uIStream.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:52:34 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 23 21:24:37 1999
// Update Count     : 41
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uOStream.h>
#include <uIStream.h>


uIStream &ws( uIStream &is ) {
    uIosWrapper wrapper( is );

    ws( is.ifile );
    return is;
} // endl

uIStream &dec( uIStream &is ) {
    uIosWrapper wrapper( is );

    dec( is.ifile );
    return is;
} // dec

uIStream &hex( uIStream &is ) {
    uIosWrapper wrapper( is );

    hex( is.ifile );
    return is;
} // hex

uIStream &oct( uIStream &is ) {
    uIosWrapper wrapper( is );

    oct( is.ifile );
    return is;
} // oct

uIStream &uAcquire( uIStream &is ) {
    is.owner.uAcquire();
    return is;
} // uAcquire

uIStream &uRelease( uIStream &is ) {
    is.owner.uRelease();
    return is;
} // uRelease

uIStream::uIStream() : ifile( new uFilebuf ) {
    iofile = &ifile;
    tied_to = (uOStream *)0;
    deletebuf = 1;
} // uIStream::uIStream

uIStream::uIStream( streambuf *buf, uOStream *tied ) : ifile( buf ) {
    iofile = &ifile;
    tied_to = tied;
    deletebuf = 0;
} // uIStream::uIStream

uIStream::~uIStream() {
    uIosWrapper wrapper( *this );

    if ( deletebuf ) {
	delete rdbuf();
    } // if
} // uIStream::~uIStream

uIStream &uIStream::get( char *ptr, int len, char delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.get( ptr, len, delim );
    return *this;
} // uIStream::get

uIStream &uIStream::get( unsigned char *ptr, int len, char delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.get( ptr, len, delim );
    return *this;
} // uIStream::get

uIStream &uIStream::get( char &c ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.get( c );
    return *this;
} // uIStream::get

uIStream &uIStream::get( unsigned char &c ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.get( c );
    return *this;
} // uIStream::get

uIStream &uIStream::get( signed char &c ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.get( c );
    return *this;
} // uIStream::get

uIStream &uIStream::get( signed char *ptr, int len, char delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.get( ptr, len, delim );
    return *this;
} // uIStream::get

uIStream &uIStream::get( streambuf &sb, char delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.get( sb, delim );
    return *this;
} // uIStream::get

uIStream &uIStream::gets( char **s, char delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.gets( s, delim );
    return *this;
} // uIStream::gets

uIStream &uIStream::getline( char *ptr, int len, char delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.getline( ptr, len, delim );
    return *this;
} // uIStream::getline

uIStream &uIStream::getline( unsigned char *ptr, int len, char delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.getline( ptr, len, delim );
    return *this;
} // uIStream::getline

uIStream &uIStream::getline( signed char *ptr, int len, char delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.getline( ptr, len, delim );
    return *this;
} // uIStream::getline

uIStream &uIStream::read( char *ptr, int n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.read( ptr, n );
    return *this;
} // uIStream::read

uIStream &uIStream::read( unsigned char *ptr, int n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.read( ptr, n );
    return *this;
} // uIStream::read

uIStream &uIStream::read( signed char *ptr, int n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.read( ptr, n );
    return *this;
} // uIStream::read

uIStream &uIStream::read( void *ptr, int n ) {
    uIosWrapper wrapper( *this );

    ifile.read( ptr, n );
    return *this;
} //  uIStream::read

int uIStream::ipfx( int need ) {
    uIosWrapper wrapper( *this );

    return ifile.ipfx( need );
} // uIStream::ipfx

int uIStream::ipfx0() {
    uIosWrapper wrapper( *this );

    return ifile.ipfx0();
} // uIStream::ipfx0

int uIStream::ipfx1() {
    uIosWrapper wrapper( *this );

    return ifile.ipfx1();
} // uIStream::ipfx1

int uIStream::get() {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    return ifile.get();
} // uIStream::get

int uIStream::peek() {
    uIosWrapper wrapper( *this );

    return ifile.peek();
} // uIStream::peek

int uIStream::gcount() {
    uIosWrapper wrapper( *this );

    return ifile.gcount();
} // uIStream::gcount

uIStream &uIStream::ignore( int n, int delim ) {
    uIosWrapper wrapper( *this );

    ifile.ignore( n, delim );
    return *this;
} // uIStream::ignore

int uIStream::sync() {
    uIosWrapper wrapper( *this );

    return ifile.sync();
} // uIStream::sync

uIStream &uIStream::seekg( streampos pos ) {
    uIosWrapper wrapper( *this );

    ifile.seekg( pos );
    return *this;
} // uIStream::seekg

uIStream &uIStream::seekg( streamoff off, ios::seek_dir dir ) {
    uIosWrapper wrapper( *this );

    ifile.seekg( off, dir );
    return *this;
} // uIStream::seekg

streampos uIStream::tellg() {
    uIosWrapper wrapper( *this );

    return ifile.tellg();
} // uIStream::tellg

uIStream &uIStream::putback( char c ) {
    uIosWrapper wrapper( *this );

    ifile.putback( c );
    return *this;
} // uIStream::putback

uIStream &uIStream::unget() {
    uIosWrapper wrapper( *this );

    ifile.unget();
    return *this;
} //  uIStream::unget

uIStream &uIStream::operator >> ( char *s ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> s;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( unsigned char *s ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> s;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( signed char *s ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> s;
    return *this;
} // uIStream::operator >>
    
uIStream &uIStream::operator >> ( char &c ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> c;
    return *this;
} // uIStream::operator >>
    
uIStream &uIStream::operator >> ( unsigned char &c ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> c;
    return *this;
} // uIStream::operator >>
    
uIStream &uIStream::operator >> ( signed char &c ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> c;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( int &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( long &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( long long &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( unsigned long long &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( short &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( unsigned int &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( unsigned long &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( unsigned short &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( bool &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( float &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( double &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

#if ! defined( __gizmo__ )				// TEMPORARY, problem with gcc 2.6.2 floating point code generation for m68k
uIStream &uIStream::operator >> ( long double &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>
#endif

uIStream &uIStream::operator >> ( uIStream &( *f )( uIStream & ) ) {
    return (*f)( *this );
} // uIStream::operator >>

uOStream *uIStream::tie() {
    return tied_to;
} // uIStream::tie

uOStream *uIStream::tie( uOStream *os ) {
    uIosWrapper wrapper( *this );

    uOStream* was = tied_to;
    tied_to = os;
    return was;
} // uIStream::tie

istream &uIStream::stream() {
    return ifile;
} // uIStream::stream


// additional GNU 2.x routines
#if __GNUG__ == 2

#ifdef _STREAM_COMPAT

uIStream &uIStream::unget( char ch ) {
    uIosWrapper wrapper( *this );

    ifile.unget( ch );
    return *this;
} //  uIStream::unget

int uIStream::skip( int i ) {
    uIosWrapper wrapper( *this );

    return ifile.skip( i );
} // uIStream::skip
    
streambuf *uIStream::uIStreambuf() {
    uIosWrapper wrapper( *this );

    return ifile.istreambuf();
} //  uIStream::uIStreambuf

#endif // _STREAM_COMPAT
#endif // __GNUG__ == 2


//######################### uIStreamModule #########################


int uIStreamBoot::count = 0;
uFilebuf *uIStreamModule::uCinFilebuf = (uFilebuf *)0;
uIStream *uIStreamModule::uCinStream = (uIStream *)0;


//######################### uIStream Boot #########################


void uIStreamBoot::startup() {
    uIStreamModule::uCinFilebuf = new uFilebuf( 0, *uKernelModule::uSystemCluster );
    uIStreamModule::uCinStream  = new uIStream( uIStreamModule::uCinFilebuf, uOStreamModule::uCoutStream );
} // uIStreamBoot::startup

void uIStreamBoot::finishup() {
    delete uIStreamModule::uCinStream;
    delete uIStreamModule::uCinFilebuf;
} // uIStreamBoot::finishup


// Local Variables: //
// compile-command: "dmake" //
// End: //
