//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1998
// 
// uIOcntl.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Jun 10 16:11:30 1998
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jun 10 16:17:43 1998
// Update Count     : 2
// 


#define __U_KERNEL__
#include <uC++.h>
//#include <uDebug.h>
#include <uIOcntl.h>


//######################### uIOlocn #########################


uIOlocn::uIOlocn( char clusterName[] ) : uOwnCluster( true ), _cluster( new uIOCluster( clusterName ) ) {
} // uIOlocn::uIOlocn

uIOlocn::uIOlocn( uIOCluster &cluster ) : uOwnCluster( false ), _cluster( &cluster ) {
} // uIOlocn::uIOlocn

uIOlocn::~uIOlocn() {
    if ( uOwnCluster ) delete _cluster;
} // uIOlocn::~uIOlocn

int uIOlocn::uSelect( int fd, int &rwe, timeval *timeout ) {
    return _cluster->uSelect( fd, rwe, timeout );
} // uIOlocn::uSelect

int uIOlocn::uSelect( fd_set *rfds, fd_set *wfds, fd_set *efds, timeval *timeout ) {
    return _cluster->uSelect( rfds, wfds, efds, timeout );
} // uIOlocn::uSelect

const uIOCluster &uIOlocn::cluster() {
    return *_cluster;
} // uIOlocn::cluster


//######################### uIOlocnWrapper #########################


uIOlocnWrapper::uIOlocnWrapper( uIOlocn &io ) : locn( io ) {
    here = &uThisTask().uMigrate( *locn._cluster );
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uIOlocnWrapper &)0x%p.uIOlocnWrapper task %s (0x%p) from cluster %s (0x%p) to cluster %s (0x%p), here %s (0x%p)\n",
	      this, uThisTask().uGetName(), &uThisTask(), uThisCluster().uGetName(), &uThisCluster(), locn._cluster->uGetName(), locn._cluster, here->uGetName(), here );
#endif __U_DEBUG_H__
} // uIOlocnWrapper::uIOlocnWrapper

uIOlocnWrapper::~uIOlocnWrapper() {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uIOlocnWrapper &)0x%p.~uIOlocnWrapper task %s (0x%p) from cluster %s (0x%p) to cluster %s (0x%p)\n",
	      this, uThisTask().uGetName(), &uThisTask(), uThisCluster().uGetName(), &uThisCluster(), here->uGetName(), here );
#endif __U_DEBUG_H__
    uThisTask().uMigrate( *here );
} // uIOlocnWrapper::~uIOlocnWrapper


// Local Variables:
// compile-command: "dmake"
// End:
