//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uIOManip.h -- parametrized manipulators as specified by ANSI draft
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:48:41 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jan 28 11:38:46 1998
// Update Count     : 13
// 


#ifndef __U_IOMANIP_H__
#define __U_IOMANIP_H__

#pragma __U_NOT_USER_CODE__


//######################### Input-Output Stream Manipulators #########################


template<class T> class SMANIP;

template<class T> class SAPP {
    uIos &(*rtn)( uIos &, T );
  public:
    SAPP( uIos &(*rtn)( uIos &, T ) ) : rtn( rtn ) {}
    SMANIP<T> operator()( T a ) {
	return SMANIP<T>( rtn, a );
    } // SAPP::SMANIP<T>
}; // SAPP

template<class T> class SMANIP {
    uIos &(*rtn)( uIos &, T );
    T arg;
  public:
    SMANIP( uIos &(*rtn)( uIos &, T ), T arg ) : rtn( rtn ), arg( arg ) {}
    friend uIStream &operator>>
#if __GNUG__ == 2 && __GNUC_MINOR__ >= 8		// releases >= 2.8
	<>
#endif
	    ( uIStream &i, const SMANIP<T> &m );
    friend uOStream &operator<<
#if __GNUG__ == 2 && __GNUC_MINOR__ >= 8		// releases >= 2.8
	<>
#endif
	    ( uOStream &o, const SMANIP<T> &m );
}; // SMANIP

template<class T> inline uIStream &operator>>( uIStream &i, const SMANIP<T> &m ) {
    m.rtn( i, m.arg );
    return i;
} // operator>>

template<class T> inline uOStream &operator<<( uOStream &o, const SMANIP<T> &m ) {
    m.rtn( o, m.arg );
    return o;
} // operator<<


//######################### Input-Stream Manipulators #########################


template<class T> class IMANIP; 

template<class T> class IAPP {
    uIStream &(*rtn)( uIStream&, T );
  public: 
    IAPP( uOStream &(*rtn)( uIStream &,T ) ) : rtn( rtn ) {}
    IMANIP<T> operator()( T arg ) {
	return IMANIP<T>( rtn, arg );
    } // IAPP::operator()
}; // IAPP

template<class T> class IMANIP {
    uIStream &(*rtn)( uIStream &, T );
    T arg;
  public:
    IMANIP( uIStream &(*rtn)( uIStream &, T ), T arg ) : rtn( rtn ), arg( arg ) {}
    friend uIStream &operator>>
#if __GNUG__ == 2 && __GNUC_MINOR__ >= 8		// releases >= 2.8
	<>
#endif
	    ( uIStream &i, const IMANIP<T> &m );
}; // IMANIP

template<class T> uIStream &operator>>( uIStream &i, const IMANIP<T> &m ) {
    return m.rtn( i, m.arg );
} // IMANIP::operator>>


//######################### Output-Stream Manipulators #########################


template<class T> class OMANIP; 

template<class T> class OAPP {
    uOStream &(*rtn)( uOStream &, T );
  public: 
    OAPP( uOStream &(*rtn)( uOStream &,T ) ) : rtn( rtn ) {}
    OMANIP<T> operator()( T arg ) {
	return OMANIP<T>( rtn, arg );
    } // OAPP::operator()
}; // OAPP

template<class T> class OMANIP {
    uOStream &(*rtn)( uOStream &, T );
    T arg;
  public:
    OMANIP( uOStream &(*rtn)( uOStream &, T ), T arg ) : rtn( rtn ), arg( arg ) {}
    friend uOStream &operator<<
#if __GNUG__ == 2 && __GNUC_MINOR__ >= 8		// releases >= 2.8
	<>
#endif
	    ( uOStream &o, OMANIP<T> &m );
}; // OMANIP

template<class T> uOStream &operator<<( uOStream &o, OMANIP<T> &m ) {
    return (uOStream &)m.rtn( o, m.arg );
} // OMANIP::operator<<


//######################### Available Manipulators #########################


// macro to build closures for manipulator routines with one argument

#define __DEFINE_IOMANIP_FN1(type,parm,rtn)	\
    extern uIos &rtn ( uIos &, parm );		\
    inline type<parm> rtn( parm n ) {		\
	return type<parm> (rtn, n);		\
    }

__DEFINE_IOMANIP_FN1( SMANIP, int, setbase )
__DEFINE_IOMANIP_FN1( SMANIP, int, setfill )
__DEFINE_IOMANIP_FN1( SMANIP, int, setprecision )
__DEFINE_IOMANIP_FN1( SMANIP, int, setw )
__DEFINE_IOMANIP_FN1( SMANIP, ios::fmtflags, setiosflags )
__DEFINE_IOMANIP_FN1( SMANIP, ios::fmtflags, resetiosflags )


#pragma __U_USER_CODE__

#endif __U_IOMANIP_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
