//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uFilebuf.h -- nonblocking stream buffer
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:45:30 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri May 31 22:35:16 1996
// Update Count     : 10
// 


#ifndef __U_FILEBUF_H__
#define __U_FILEBUF_H__

#include <uFile.h>

#pragma __U_NOT_USER_CODE__

#include <streambuf.h>

#define __U_BUFFER_SIZE__ 512

class uFilebuf : public streambuf {
    uFile *ufile;
    uFileAccess *ufileacc;
    char buffer[__U_BUFFER_SIZE__];
    int endOfFile;

#ifndef __GNUG__
    // GNU filebuf violates abstraction by directly accessing variables in streambuf.
    // For non-GNU implementations, it is easier to fake the GNU stuff rather than
    // #ifdef the code to death.

    enum xfakeflags { _S_NO_READS, _S_NO_WRITES };
    void xsetflags( int f, int mask ) { f = 0; mask = 0; }
#endif

    int IosToUnixMode( int mode );
    int CharToUnixMode( const char *mode );
  public:
    uFilebuf();
    uFilebuf( int fd, uIOCluster &cluster, int bufsize = __U_BUFFER_SIZE__ );
    uFilebuf( int fd, uIOCluster &cluster, char *p, int len );
    virtual ~uFilebuf();

    int is_open();
    int fd();
    uFilebuf *open( const char *filename, int mode, int prot = 0644 );
    uFilebuf *open( const char *filename, uIOCluster &cluster, int mode, int prot = 0644 );
    uFilebuf *attach( int fd, uIOCluster &cluster );
    int close();

    virtual int overflow( int c = EOF );
    virtual int underflow();
    virtual int sync();
    virtual streampos seekoff( streamoff off, ios::seek_dir dir, int mode = ios::in | ios::out );

// additional GNU 2.x routines
#if __GNUG__ == 2
    uFilebuf *open( const char *filename, const char *mode );
    uFilebuf *open( const char *filename, uIOCluster &cluster, const char *mode );
#endif // __GNUG__ == 2
}; // uFilebuf


#pragma __U_USER_CODE__

#endif __U_FILEBUF_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
