//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uFilebuf.cc -- nonblocking stream buffer
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:46:30 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Sep  6 16:58:08 1997
// Update Count     : 30
// 


#define __U_KERNEL__
#include <uC++.h>
//#include <uDebug.h>
#include <uFilebuf.h>


#include <string.h>
#include <fcntl.h>
#include <unistd.h>


// I would like to make it known that I have no idea what half this code does.
// I think this stream stuff is someone's idea of a bad joke.

int uFilebuf::IosToUnixMode( int mode ) {
    int m, rw;

    if ( (mode & (ios::in|ios::out)) == (ios::in|ios::out) ) {
	m = O_RDWR;
	rw = 0;
    } else if ( mode & (ios::out|ios::app) ) {
	m = O_WRONLY;
	rw = _IO_NO_READS;
    } else if ( mode & (int)ios::in ) {
	m = O_RDONLY;
	rw = _IO_NO_WRITES;
    } else {
	uAbort( "IosToUnixMode( 0x%p ): invalid I/O mode", mode );
    } // if

    xsetflags( rw, _IO_NO_READS + _IO_NO_WRITES );	// magic

    if ( (mode & (int)ios::trunc) || mode == (int)ios::out ) {
	m |= O_TRUNC;
    } // if
    if ( mode & ios::app ) {
	m |= O_APPEND;
    } // if
    if ( !(mode & (int)ios::nocreate) && mode != ios::in ) {
	m |= O_CREAT;
    } // if
    if ( mode & (int)ios::noreplace ) {
	m |= O_EXCL;
    } // if

    return m;
} // uFilebuf::IosToUnixMode

int uFilebuf::CharToUnixMode( const char *mode ) {
    int m, rw;

    if ( strcmp( mode, "r" ) == 0 ) {			// convert
	m = O_RDONLY;
	rw = _IO_NO_WRITES;
    } else if ( strcmp( mode, "w" ) == 0 ) {
	m = O_WRONLY | O_CREAT;
	rw = _IO_NO_READS;
    } else if ( strcmp( mode, "a" ) == 0 ) {
	m = O_WRONLY | O_APPEND | O_CREAT;
	rw = _IO_NO_READS;
    } else if ( strcmp( mode, "r+" ) == 0 ) {
	m = O_RDWR;
	rw = 0;
    } else if ( strcmp( mode, "w+" ) == 0 ) {
	m = O_RDWR | O_TRUNC | O_CREAT;
	rw = 0;
    } else if ( strcmp( mode, "a+" ) == 0 ) {
	m = O_RDWR | O_APPEND | O_CREAT;
	rw = 0;
    } else {
	uAbort( "CharToUnixMode( %s ): invalid I/O mode (r,w,r+,a+,w+)", mode );
    } // if

    xsetflags( rw, _IO_NO_READS + _IO_NO_WRITES );	// magic

    return m;
} // uFilebuf::CharToUnixMode

uFilebuf::uFilebuf() {
    ufile = 0;
    ufileacc = 0;
    setbuf( buffer, __U_BUFFER_SIZE__ );		// reset all buffer pointers
    endOfFile = 0;
} // uFilebuf::uFilebuf

uFilebuf::uFilebuf( int fd, uIOCluster &cluster, int bufsize ) {
    ufile = new uFile( "/dev/tty", cluster );
    ufileacc = new uFileAccess( fd, *ufile );
    setbuf( buffer, bufsize );				// reset all buffer pointers
    endOfFile = 0;
} // uFilebuf::uFilebuf

uFilebuf::uFilebuf( int fd, uIOCluster &cluster, char *buf, int bufsize ) {
    ufile = new uFile( "unknown", cluster );
    ufileacc = new uFileAccess( fd, *ufile );
    setbuf( buf, bufsize );				// reset all buffer pointers
    endOfFile = 0;
} // uFilebuf::uFilebuf

uFilebuf::~uFilebuf() {
    close();
} // uFilebuf::~uFilebuf

int uFilebuf::is_open() {
    return ufileacc != 0;
} // uFilebuf::is_open

int uFilebuf::fd() {
    if ( is_open() ) {
	return ufileacc->access.fd;
    } else {
	return EOF;
    } // if
} // uFilebuf::fd

uFilebuf *uFilebuf::open( const char *filename, int mode, int prot ) {
    if ( is_open() ) close();
    ufile = new uFile( filename );
    ufileacc = new uFileAccess( *ufile, IosToUnixMode( mode ), prot );
    if ( mode & ios::ate ) {				// seek to the end of the file
	seekoff( 0, ios::end );
    } // if
    return this;
} // uFilebuf::open

uFilebuf *uFilebuf::open( const char *filename, uIOCluster &cluster, int mode, int prot ) {
    if ( is_open() ) close();
    ufile = new uFile( filename, cluster );
    ufileacc = new uFileAccess( *ufile, IosToUnixMode( mode ), prot );
    if ( mode & ios::ate ) {				// seek to the end of the file
	seekoff( 0, ios::end );
    } // if
    return this;
} // uFilebuf::open

uFilebuf *uFilebuf::attach( int, uIOCluster & ) {
    uAbort( "uFilebuf::attach, operation not supported" );
    return (uFilebuf *)0;
} // uFilebuf::attach

int uFilebuf::close() {
    if ( is_open() ) {
	delete ufileacc;
	ufileacc = 0;
    } // if
    if ( ufile != 0 ) {
	delete ufile;
	ufile = 0;
    } // if
    return 0;
} // uFilebuf::close

int uFilebuf::overflow( int c ) {
  if ( !is_open() ) return EOF;				// file open ?

    int len, wbytes;
    char *pos;

    for ( pos = pbase(), len = pptr() - pbase(); len != 0; pos += wbytes, len -= wbytes ) {
	wbytes = ufileacc->write( pos, len );
    } // for

#ifdef __U_DEBUG_H__
    uDebugPrt( "overflow( %c ), base:0x%p, ebuf:0x%p, eback:0x%p, gptr:0x%p, egptr:0x%p, pbase:0x%p, pptr:0x%p, epptr:0x%p, len:%d\n", c, base(), ebuf(), eback(), gptr(), egptr(), pbase(), pptr(), epptr(), pptr() - pbase() );
#endif __U_DEBUG_H__

    setp( base(), ebuf() );				// reset output buffer pointers
    if ( c != EOF ) {					// character passed ?
	sputc( c );					// insert into empty buffer
    } // if

    return 0;
} // uFilebuf::overflow

int uFilebuf::underflow() {
  if ( !is_open() ) return EOF;				// file open ?

    int rbytes;
    int c;

    // There are times (getline) when underflow is called after EOF has already
    // been returned. To prevent having to enter multiple C-ds from stdin,
    // additional reads must not be done.

    if ( !endOfFile ) {
	rbytes = ufileacc->read( base(), ebuf() - base() );
    } else {
	rbytes = 0;
    } // if
    setg( base(), base(), base() + rbytes );		// reset input buffer pointers
    if ( rbytes == 0 ) {				// zero bytes read ?
	endOfFile = 1;
	c = EOF;
    } else {
	c = sgetc();					// get the next character from the buffer
    } // if

#ifdef __U_DEBUG_H__
    uDebugPrt( "c:%c = underflow(), rbytes:%d, base:0x%p, ebuf:0x%p, eback:0x%p, gptr:0x%p, egptr:0x%p, pbase:0x%p, pptr:0x%p, epptr:0x%p\n", c, rbytes, base(), ebuf(), eback(), gptr(), egptr(), pbase(), pptr(), epptr() );
#endif __U_DEBUG_H__

    return c;
} // uFilebuf::underflow

int uFilebuf::sync() {
    if ( pptr() > pbase() ) {
	overflow();					// empty output buffer
//	ufileacc->fsync();				// sync to disk
    } // if
    return 0;
} // uFilebuf::sync

streampos uFilebuf::seekoff( streamoff off, ios::seek_dir dir, int ) {
    streampos pos;

    if ( dir == ios::beg ) {
	ufileacc->lseek( 0, SEEK_SET );			// seek to origin
	pos = ufileacc->lseek( off, SEEK_SET );
    } else if ( dir == ios::cur ) {
	pos = ufileacc->lseek( off, SEEK_CUR );
    } else {
	pos = ufileacc->lseek( off, SEEK_END );
    } // if

    setbuf( buffer, ebuf() - base() );			// reset all buffer pointers
    return pos;
} // uFilebuf::seekoff

// additional GNU 2.x routines
#if __GNUG__ == 2

uFilebuf *uFilebuf::open( const char *filename, const char *mode ) {
    if ( is_open() ) close();
    ufile = new uFile( filename );
    ufileacc = new uFileAccess( *ufile, CharToUnixMode( mode ) );
    return this;
} // uFilebuf::open

uFilebuf *uFilebuf::open( const char *filename, uIOCluster &cluster, const char *mode ) {
    if ( is_open() ) close();
    ufile = new uFile( filename, cluster );
    ufileacc = new uFileAccess( *ufile, CharToUnixMode( mode ) );
    return this;
} // uFilebuf::open

#endif // __GNUG__ == 2


// Local Variables: //
// compile-command: "dmake" //
// End: //
