//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uFStream.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:36:16 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri May 31 22:32:52 1996
// Update Count     : 10
// 


#ifndef __U_FSTREAM_H__
#define __U_FSTREAM_H__


#include <uIOStream.h>

#pragma __U_NOT_USER_CODE__


//######################### uIFStream #########################


class uIFStream : public uIStream {
    uIFStream( uIFStream & );				// no copy
    uIFStream &operator=( uIFStream & );		// no assignment
  public:
    uIFStream();
    uIFStream( const char *name, int mode = ios::in, int prot = 0644 );
    uIFStream( const char *name, uIOCluster &cluster, int mode = ios::in, int prot = 0644 );
    uIFStream( int fd, uIOCluster &cluster );
    uIFStream( int fd, uIOCluster &cluster, char *buf, int bufsize );
    void attach( int fd, uIOCluster &cluster );
    void open( const char *name, int mode = ios::in, int prot = 0644 );
    void open( const char *name, uIOCluster &cluster, int mode = ios::in, int prot = 0644 );
    void close();
    uFilebuf *rdbuf();
}; // uIFStream


//######################### uOFStream #########################


class uOFStream : public uOStream {
    uOFStream( uOFStream & );				// no copy
    uOFStream &operator=( uOFStream & );		// no assignment
  public:
    uOFStream();
    uOFStream( const char *name, int mode = ios::out, int prot = 0644 );
    uOFStream( const char *name, uIOCluster &cluster, int mode = ios::out, int prot = 0644 );
    uOFStream( int fd, uIOCluster &cluster );
    uOFStream( int fd, uIOCluster &cluster, char *buf, int bufsize );
    void attach( int fd, uIOCluster &cluster );
    void open( const char *name, int mode = ios::out, int prot = 0644 );
    void open( const char *name, uIOCluster &cluster, int mode = ios::out, int prot = 0644 );
    void close();
    uFilebuf *rdbuf();
}; // uOFStream


#pragma __U_USER_CODE__

#endif // __U_FSTREAM_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
