//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uFStream.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:37:41 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Apr  9 17:13:36 1995
// Update Count     : 9
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uFStream.h>


//######################### uIFStream #########################


uIFStream::uIFStream() : uIStream( new uFilebuf ) {
    deletebuf = 1;
} // uIFStream::uIFStream

uIFStream::uIFStream( const char *name, int mode, int prot ) : uIStream( new uFilebuf ) {
    deletebuf = 1;
    rdbuf()->open( name, mode, prot );
} // uIFStream::uIFStream

uIFStream::uIFStream( const char *name, uIOCluster &cluster, int mode, int prot ) : uIStream( new uFilebuf ) {
    deletebuf = 1;
    rdbuf()->open( name, cluster, mode, prot );
} // uIFStream::uIFStream

uIFStream::uIFStream( int fd, uIOCluster &cluster ) : uIStream( new uFilebuf( fd, cluster ) ) {
    deletebuf = 1;
} // uIFStream::uIFStream

uIFStream::uIFStream( int fd, uIOCluster &cluster, char *buf, int bufsize ) : uIStream( new uFilebuf( fd, cluster, buf, bufsize ) ) {
    deletebuf = 1;
} // uIFStream::uIFStream

void uIFStream::attach( int fd, uIOCluster &cluster ) {
    uIosWrapper wrapper( *this );

    rdbuf()->attach( fd, cluster );
} // uIFStream::attach

void uIFStream::open( const char *name, int mode, int prot ) {
    uIosWrapper wrapper( *this );

    rdbuf()->open( name, mode, prot );
} // uIFStream::uIFStream

void uIFStream::open( const char *name, uIOCluster &cluster, int mode, int prot ) {
    uIosWrapper wrapper( *this );

    rdbuf()->open( name, cluster, mode, prot );
} // uIFStream::uIFStream

void uIFStream::close() {
    uIosWrapper wrapper( *this );

    rdbuf()->close();
} // uIFStream::close

uFilebuf *uIFStream::rdbuf() {
    return (uFilebuf *)uIStream::rdbuf();
} // uIFStream::rdbuf


//######################### uOFStream #########################


uOFStream::uOFStream() : uOStream( new uFilebuf ) {
    deletebuf = 1;
} // uOFStream::uOFStream

uOFStream::uOFStream( const char *name, int mode, int prot ) : uOStream( new uFilebuf ) {
    deletebuf = 1;
    rdbuf()->open( name, mode, prot );
} // uOFStream::uOFStream

uOFStream::uOFStream( const char *name, uIOCluster &cluster, int mode, int prot ) : uOStream( new uFilebuf ) {
    deletebuf = 1;
    rdbuf()->open( name, cluster, mode, prot );
} // uOFStream::uOFStream

uOFStream::uOFStream( int fd, uIOCluster &cluster ) : uOStream( new uFilebuf( fd, cluster ) ) {
    deletebuf = 1;
} // uOFStream::uOFStream

uOFStream::uOFStream( int fd, uIOCluster &cluster, char *buf, int bufsize ) : uOStream( new uFilebuf( fd, cluster, buf, bufsize ) ) {
    deletebuf = 1;
} // uOFStream::uOFStream

void uOFStream::attach( int fd, uIOCluster &cluster ) {
    uIosWrapper wrapper( *this );

    rdbuf()->attach( fd, cluster );
} // uOFStream::attach

void uOFStream::open( const char *name, int mode, int prot ) {
    uIosWrapper wrapper( *this );

    rdbuf()->open( name, mode, prot );
} // uOFStream::uOFStream

void uOFStream::open( const char *name, uIOCluster &cluster, int mode, int prot ) {
    uIosWrapper wrapper( *this );

    rdbuf()->open( name, cluster, mode, prot );
} // uOFStream::uOFStream

void uOFStream::close() {
    uIosWrapper wrapper( *this );

    rdbuf()->close();
} // uOFStream::close

uFilebuf *uOFStream::rdbuf() {
    return (uFilebuf *)uOStream::rdbuf();
} // uOFStream::rdbuf


// Local Variables: //
// compile-command: "dmake" //
// End: //
