//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1995
// 
// uBarrier.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sat Sep 16 20:56:38 1995
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May 22 11:43:19 1999
// Update Count     : 25
// 


#ifndef __U_BARRIER_H__
#define __U_BARRIER_H__

#pragma __U_NOT_USER_CODE__


uMutex uCoroutine uBarrier {
    uCondition waiters;
    unsigned int total, count;

    void init( unsigned int total ) {
	count = 0;
	uBarrier::total = total;
    } // uBarrier::init
  protected:
    virtual void main() {
	for ( ;; ) {
	    uSuspend;
	} // for
    } // uBarrier::main
  public:
    uBarrier( unsigned int total ) {
	init( total );
    } // uBarrier::uBarrier

    virtual ~uBarrier() {
    } // uBarrier::~uBarrier

    void uReset( unsigned int total ) {
#ifdef __U_DEBUG__
	if ( count != 0 ) {
	    uAbort( "(uBarrier *)0x%p.uReset( %d ) : attempt to reset barrier total while tasks blocked on barrier.", this, total );
	} // if
#endif __U_DEBUG__
	init( total );
    } // uBarrier::uReset

    uNoMutex unsigned int uTotal() const {		// total participants in the barrier
	return total;
    } // uBarrier::uTotal

    uNoMutex unsigned int uWaiters() const {		// number of waiting tasks
	return count;
    } // uBarrier::uWaiters

    void uBlock() {
	count += 1;
	if ( count < total ) {				// all tasks arrived ?
	    uWait waiters;
	} else {
	    uLast();					// call the last routine
	    count = 0;
	    for ( ; ! waiters.uEmpty(); ) {		// restart all waiting tasks
		uSignal waiters;
	    } // for
	} // if
    } // uBarrier::uBlock

    virtual void uLast() {				// called by last task to reach the barrier
	uResume;
    } // uBarrier::uLast
}; // uBarrier


#pragma __U_USER_CODE__

#endif __U_BARRIER_H__


// Local Variables:
// compile-command: "dmake"
// End:
