//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1998
// 
// uSystemTask.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Jun 22 15:25:53 1998
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Dec  5 17:23:48 1998
// Update Count     : 24
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uSystemTask.h>
//#include <uDebug.h>


void uSystemTask::main() {
    for ( ;; ) {
	uAccept( ~uSystemTask ) {
	    break;
	} uOr uAccept( uReaper ) {
	    delete victim;
	} uOr uTimeout( uDuration( 1, 0 ) ) {
	} // uAccept

#if __U_LOCALDEBUGGER_H__
	// check for debugger attack request

	if ( uKernelModule::uAttaching != 0 ) {
#ifdef __U_DEBUG_H__
	    uDebugPrt( "(uSystemTask &)0x%p.main, attaching\n", this );
#endif __U_DEBUG_H__ 
	    int port = uKernelModule::uAttaching;
	    uKernelModule::uAttaching = 0;		// reset flag so don't do this again
	    uLocalDebugger::uLocalDebuggerInstance = new uLocalDebugger( port );
#ifdef __U_DEBUG_H__
	    uDebugPrt( "(uSystemTask &)0x%p.main, local debugger started\n", this );
#endif __U_DEBUG_H__
	} // if

#ifndef __U_MULTI__
	if ( uKernelModule::uDeadlock ) {
	    uAbort( ": no ready or pending tasks.\n"
		    "Possible cause is tasks in a synchronization or mutual exclusion deadlock.", this );
	} // if
#endif ! __U_MULTI__
#endif __U_LOCALDEBUGGER_H__

	if ( uKernelModule::uTerminate ) {
	    uAbort( ": application interrupted by a termination signal." );
	} // if
    } // for
} // uSystemTask::main


uSystemTask::uSystemTask() : uBaseTask( *uKernelModule::uSystemCluster ) {
} // uSystemTask::uSystemTask


uSystemTask::~uSystemTask() {
} // uSystemTask::~uSystemTask

void uSystemTask::uReaper( uBaseTask &victim ) {
    uSystemTask::victim = &victim;
} // uSystemTask::uReaper


// Local Variables: //
// compile-command: "dmake" //
// End: //
