!                               -*- Mode: Asm -*- 
! 
! uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
! 
! uSwitch-sparc.s -- 
! 
! Author           : Peter Buhr
! Created On       : Tue Mar  1 14:42:19 1994
! Last Modified By : Peter A. Buhr
! Last Modified On : Sat Sep  2 12:39:53 1995
! Update Count     : 25
! 

! include some machine dependent values

#ifdef __svr4__
#include <sys/asm_linkage.h>
#define USWITCH uSwitch
#else
#include <machine/trap.h>
#include <machine/asm_linkage.h>
#include <machine/psl.h>
#define USWITCH uSwitch
#endif __svr4__

! Offsets in the context structure. This needs to be synchronized with the
! high level code a little better.

#define SP_OFFSET	0
#define FP_OFFSET	4
#define PC_OFFSET	8


! This context switch routine depends on the fact that the stack of a new
! thread has been set up to look like the thread has saved its context in
! the normal manner.
!
! void uSwitch( uMachContext *to, uMachContext *from );

#ifdef __svr4__
	.file	"uSwitch-sparc.s"
	.section ".text"
#endif __svr4__
	.proc	4
	.align	4
	.global	USWITCH
USWITCH:

	! Establish a minimal frame.

	save %sp,-SA(MINFRAME),%sp

	! Save all stack window registers.

	ta ST_FLUSH_WINDOWS

	! Save old context in the "from" area.

	st %sp,[%i1+SP_OFFSET]
	st %fp,[%i1+FP_OFFSET]
	st %i7,[%i1+PC_OFFSET]

	! Load new context from the "to" area.

	ld [%i0+PC_OFFSET],%i7
	ld [%i0+FP_OFFSET],%fp
	ld [%i0+SP_OFFSET],%sp

	! Return to thread.

	ret

	! Pop back one register frame, causing the in and local registers
	! to be loaded from memory.

	restore
#ifdef __svr4__
	.type	USWITCH,#function
	.size	USWITCH,(.-USWITCH)
#endif __svr4__

!! Local Variables: !!
!! compile-command: "dmake" !!
!! End: !!
