 #                               -*- Mode: Asm -*- 
 # 
 # uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1995
 # 
 # uSwitch-rs6000.s -- 
 # 
 # Author           : Peter A. Buhr
 # Created On       : Sat May 13 10:19:56 1995
 # Last Modified By : Peter A. Buhr
 # Last Modified On : Fri Jan 19 11:16:00 1996
 # Update Count     : 10
 # 

 # This context switch routine depends on the fact that the stack of a new
 # thread has been set up to look like the thread has saved its context in
 # the normal manner.
 #
 # void uSwitch( uMachContext *to, uMachContext *from );

	.file	"uSwitch-rs6000.s"
.toc
.csect	.text[PR]
	.align 2
	.globl uSwitch
	.globl .uSwitch
.csect uSwitch[DS]
uSwitch:
	.long .uSwitch, TOC[tc0], 0
.csect	.text[PR]
.uSwitch:

	# Save condition code register in caller's link area.

	mfcr 0
	st 0,4(1)

	# Save return address in caller's link area.

	mflr 0
	st 0,8(1)

	# Save TOC register in caller's link area.

	st 2,20(1)

	# Save volatile registers (13-31) on the stack.

	stu 1,-76(1)			# decrement stack 76 bytes
	stm 13,0(1)			# store fixed registers

	# Save stack pointer in "from" area at offset 0.

	st 1,0(4)

	# Load stack pointer from the "to" area at offset 0.

	l 1,0(3)

	# Load volatile registers (13-31) from the stack

	lm 13,0(1)			# restore fixed registers
	ai 1,1,76			# increment stack 76 bytes

	# Load TOC register from caller's link area.

	l 2,20(1)

	# Load return address from caller's link area.

	l 0,8(1)
	mtlr 0

	# Load condition code register from link area.

	l  0,4(1)
	mtcr 0

	# As well, the "to" parameter in $3 magically becomes the "This"
	# argument for uMachContext::uInvoke. Only significant when a new
	# thread starts.

	# Return to thread.

	br

 # define end of routine

LT..uSwitch:
	.long 0
	.byte 0,0,32,96,128,1,2,1
	.long 0
	.long LT..uSwitch-.uSwitch
	.short 7
	.byte "uSwitch"
	.byte 31
_section_.text:
.csect	.data[RW]
	.long _section_.text

 ## Local Variables: ##
 ## compile-command: "dmake" ##
 ## End: ##
