 #                               -*- Mode: Asm -*- 
 # 
 # uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
 # 
 # uSwitch-mip.s -- 
 # 
 # Author           : Peter A. Buhr
 # Created On       : Wed Nov  9 10:16:30 1994
 # Last Modified By : Peter A. Buhr
 # Last Modified On : Tue Jan  5 18:01:36 1999
 # Update Count     : 15
 # 

 # This context switch routine depends on the fact that the stack of a new
 # thread has been set up to look like the thread has saved its context in
 # the normal manner.
 #
 # void uSwitch( uMachContext *to, uMachContext *from );

	.text
	.align 2
	.globl uSwitch
	.ent uSwitch
uSwitch:
	.frame	$sp,0,$31
	.mask	0x00000000,0
	.fmask	0x00000000,0
	.set	noreorder

	# Save volatile registers (16-23,30,31) on the stack.

	subu $sp,48				# multiple of 16
	sw $16,0($sp)
	sw $17,4($sp)
	sw $18,8($sp)
	sw $19,12($sp)
	sw $20,16($sp)
	sw $21,20($sp)
	sw $22,24($sp)
	sw $23,28($sp)
	sw $30,32($sp)
	sw $31,36($sp)

	# Save stack pointer in the "from" area at offset 0.

	sw $sp,0($5)

	# Load stack pointer from the "to" area at offset 0.

	lw $sp,0($4)
	nop					# delay slot

	# Load volatile registers (16-23,30,31) from the stack.

	lw $31,36($sp)
	lw $30,32($sp)
	lw $23,28($sp)
	lw $22,24($sp)
	lw $21,20($sp)
	lw $20,16($sp)
	lw $19,12($sp)
	lw $18,8($sp)
	lw $17,4($sp)
	lw $16,0($sp)
	addu $sp,48

	# Load the procedure address for global addressability from new context
	# offset 4. Only significant when a new thread starts.

	lw $25,4($4)

	# As well, the "to" parameter in $4 magically becomes the "This"
	# argument for uMachContext::uInvoke. Only significant when a new
	# thread starts.

	# Return to thread.

	j $31
	nop					# delay slot

 # define end of routine

	.set	reorder
 	.end	uSwitch

 ## Local Variables: ##
 ## compile-command: "dmake" ##
 ## End: ##
