#                               -*- Mode: Asm -*- 
# 
# uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1995
# 
# uSwitch-m68k.s -- 
# 
# Author           : Peter A. Buhr
# Created On       : Mon Jan  2 20:55:37 1995
# Last Modified By : Peter A. Buhr
# Last Modified On : Sat Sep  2 12:38:08 1995
# Update Count     : 9
# 

# This context switch routine depends on the fact that the stack of a new
# thread has been set up to look like the thread has saved its context in
# the normal manner.
#
# void uSwitch( uMachContext *to, uMachContext *from );

.text
	.even
.globl	uSwitch
uSwitch:

	| Copy the "from" context argument from the stack to register a0

	movel sp@(8),a0

	| Save volatile registers (d2-d7,a2-a5,fp) on the stack.

	moveml #0x3f3e,sp@-

	| Save stack pointer in the "from" area at offset 0.

	movel sp,a0@

	| Copy the "to" context argument from the stack to register a0

	movel sp@(48),a0

	| Load stack pointer from the "to" area at offset 0.

	movel a0@,sp

	| Load volatile registers (d2-d7,a2-a5,fp) from the stack.

	moveml sp@+,#0x7cfc

	| Return to thread.

	rts

## Local Variables: ##
## compile-command: "dmake" ##
## End: ##
