#                               -*- Mode: Asm -*- 
# 
# uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
# 
# uSwitch-i386.s -- 
# 
# Author           : Peter A. Buhr
# Created On       : Sun Oct  9 11:46:38 1994
# Last Modified By : Peter A. Buhr
# Last Modified On : Thu Nov 14 09:57:10 1996
# Update Count     : 15
# 

# This context switch routine depends on the fact that the stack of a new
# thread has been set up to look like the thread has saved its context in
# the normal manner.
#
# void uSwitch( uMachContext *to, uMachContext *from );

.text
	.align 2
.globl	uSwitch
uSwitch:

	# Copy the "from" context argument from the stack to register eax
	
	movl 8(%esp),%eax

	# Save volatile registers on the stack.

	pushl %ebx
	pushl %edi
	pushl %esi

	# Save old context in the "from" area.

	movl %esp,0(%eax)
	movl %ebp,4(%eax)
	movl 4(%ebp),%ebx	# save previous eip for debugger
	movl %ebx,8(%eax)

	# Copy the "to" context argument from the stack to register eax

	movl 16(%esp),%eax

	# Load new context from the "to" area.

	movl 0(%eax),%esp
	movl 4(%eax),%ebp

	# Load volatile registers from the stack.

	popl %esi
	popl %edi
	popl %ebx

	# Return to thread.

	ret

## Local Variables: ##
## compile-command: "dmake" ##
## End: ##
