 ;                               -*- Mode: Asm -*- 
 ; 
 ; uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1995
 ; 
 ; uSwitch-hppa.s -- 
 ; 
 ; Author           : Peter Buhr
 ; Created On       : Wed May 31 23:23:18 1995
 ; Last Modified By : Peter A. Buhr
 ; Last Modified On : Fri Jan 19 11:17:43 1996
 ; Update Count     : 9
 ; 

 ; This context switch routine depends on the fact that the stack of a new
 ; thread has been set up to look like the thread has saved its context in
 ; the normal manner.
 ;
 ; void uSwitch( uMachContext *to, uMachContext *from );

	.SPACE $PRIVATE$
	.SUBSPA $DATA$,QUAD=1,ALIGN=8,ACCESS=31
	.SUBSPA $BSS$,QUAD=1,ALIGN=8,ACCESS=31,ZERO,SORT=82
	.SPACE $TEXT$
	.SUBSPA $LIT$,QUAD=0,ALIGN=8,ACCESS=44
	.SUBSPA $CODE$,QUAD=0,ALIGN=8,ACCESS=44,CODE_ONLY
	.IMPORT $global$,DATA

	.align 4
	.EXPORT uSwitch,CODE
	.EXPORT uSwitch,ENTRY,PRIV_LEV=3,ARGW0=GR
uSwitch
	.PROC
	.CALLINFO FRAME=64,NO_CALLS
	.ENTRY

	; Save return address in caller's link area.

	stw %r2,-20(0,%r30)

	; Save volatile registers on the stack.

	ldo 192(%r30),%r30			; increment stack 192 bytes
	stw %r3, -36(0,%r30)			; save r3-r18, while leaving room for a stack frame at top of stack
	stw %r4, -40(0,%r30)
	stw %r5, -44(0,%r30)
	stw %r6, -48(0,%r30)
	stw %r7, -52(0,%r30)
	stw %r8, -56(0,%r30)
	stw %r9, -60(0,%r30)
	stw %r10,-64(0,%r30)
	stw %r11,-68(0,%r30)
	stw %r12,-72(0,%r30)
	stw %r13,-76(0,%r30)
	stw %r14,-80(0,%r30)
	stw %r15,-84(0,%r30)
	stw %r16,-88(0,%r30)
	stw %r17,-92(0,%r30)
	stw %r18,-96(0,%r30)
	ldo -96(%r30),%r1			; r1 walks down the stack as fp registers are saved
	fstds,mb %fr12,-8(0,%r1)		; save fr12-fr16 for 1.0 and fr12-fr21 for 1.1
	fstds,mb %fr13,-8(0,%r1)
	fstds,mb %fr14,-8(0,%r1)
	fstds,mb %fr15,-8(0,%r1)
	fstds,mb %fr16,-8(0,%r1)
	fstds,mb %fr17,-8(0,%r1)
	fstds,mb %fr18,-8(0,%r1)
	fstds,mb %fr19,-8(0,%r1)
	fstds,mb %fr20,-8(0,%r1)
	fstds,mb %fr21,-8(0,%r1)

	; Save stack pointer in the "from" area at offset 0.

	stw %r30,0(0,%r25)

	; Load stack pointer from the "to" area at offset 0.

	ldw 0(0,%r26),%r30

	; Load volatile registers from the stack.

	ldo -96(%r30),%r1			; r1 walks down the stack as fp registers are restored
	fldds,mb -8(0,%r1),%fr12		; restore fr12-fr16 for 1.0 and fr12-fr21 for 1.1
	fldds,mb -8(0,%r1),%fr13
	fldds,mb -8(0,%r1),%fr14
	fldds,mb -8(0,%r1),%fr15
	fldds,mb -8(0,%r1),%fr16
	fldds,mb -8(0,%r1),%fr17
	fldds,mb -8(0,%r1),%fr18
	fldds,mb -8(0,%r1),%fr19
	fldds,mb -8(0,%r1),%fr20
	fldds,mb -8(0,%r1),%fr21
	ldw -36(0,%r30),%r3	 		; restore r3-r18
	ldw -40(0,%r30),%r4
	ldw -44(0,%r30),%r5
	ldw -48(0,%r30),%r6
	ldw -52(0,%r30),%r7
	ldw -56(0,%r30),%r8
	ldw -60(0,%r30),%r9
	ldw -64(0,%r30),%r10
	ldw -68(0,%r30),%r11
	ldw -72(0,%r30),%r12
	ldw -76(0,%r30),%r13
	ldw -80(0,%r30),%r14
	ldw -84(0,%r30),%r15
	ldw -88(0,%r30),%r16
	ldw -92(0,%r30),%r17
	ldw -96(0,%r30),%r18
	ldo -192(%r30),%r30			; decrement stack 192 bytes

	; Load return address from caller's link area.

	ldw -20(0,%r30),%r2

	; As well, the "to" parameter in $26 magically becomes the "This"
	; argument for uMachContext::uInvoke. Only significant when a new
	; thread starts.

	; Return to thread.

	bv 0(%r2)
	nop					; delay slot

 ; define end of routine

	.EXIT
	.PROCEND

 ;; Local Variables: ;;
 ;; compile-command: "dmake" ;;
 ;; End: ;;
