 #                               -*- Mode: Asm -*- 
 # 
 # uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1995
 # 
 # uSwitch-alpha.s -- 
 # 
 # Author           : Peter A. Buhr
 # Created On       : Sun Jan 15 10:52:17 1995
 # Last Modified By : Peter A. Buhr
 # Last Modified On : Fri Jan 19 11:13:23 1996
 # Update Count     : 19
 # 

 # This context switch routine depends on the fact that the stack of a new
 # thread has been set up to look like the thread has saved its context in
 # the normal manner.
 #
 # void uSwitch( uMachContext *to, uMachContext *from )

	.set noreorder
	.set volatile
	.set noat
	.file	1 "uSwitch-alpha.s"
.text
	.align	3
	.globl	uSwitch
	.ent	uSwitch
uSwitch:

	# Save volatile registers s0(r9)-s5(r14),fp(r15),ra(r26) on the stack.

	lda $sp,-64($sp)
	stq $9,0($sp)
	stq $10,8($sp)
	stq $11,16($sp)
	stq $12,24($sp)
	stq $13,32($sp)
	stq $14,40($sp)
	stq $fp,48($sp)
	stq $26,56($sp)

	# Save stack pointer in the "from" area at offset 0.

	stq $sp,0($17)

	# Load stack pointer from the "to" area at offset 0.

	ldq $sp,0($16)

	# Load volatile registers s0(r9)-s5(r14),fp(r15),ra(r26) on the stack.

	ldq $26,56($sp)
	ldq $fp,48($sp)
	ldq $14,40($sp)
	ldq $13,32($sp)
	ldq $12,24($sp)
	ldq $11,16($sp)
	ldq $10,8($sp)
	ldq $9,0($sp)
	lda $sp,64($sp)

	# Load the procedure address for global addressability from new context
	# offset 8, only significant when a new thread starts.

	ldq $27,8($16)

	# As well, the "to" parameter in $16 magically becomes the "This"
	# argument for uMachContext::uInvoke. Only significant when a new
	# thread starts.

	# Return to thread.

	ret $31,($26),1
	.end uSwitch

 ## Local Variables: ##
 ## compile-command: "dmake" ##
 ## End: ##
