//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
// 
// uSignal.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sun Dec 19 16:32:13 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jun  1 16:44:51 1999
// Update Count     : 496
// 


#define __U_KERNEL__
#include <uC++.h>
//#include <uDebug.h>
#ifdef __U_DEBUG_H__
#include "uProfiler.h"
#include "uSymbolTable.h"
#endif __U_DEBUG_H__

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <string.h>
#ifdef __svr4__
#include <ucontext.h>
#endif
#include <sys/types.h>
#include <errno.h>


#if ! defined( __svr4__ ) && defined( __sun__ )
extern "C" int sigsetmask(int);				// missing from signal.h
extern "C" int sigblock(int);				// missing from signal.h
extern "C" int sigvec(int, struct sigvec *, struct sigvec *);  // missing from signal.h
extern "C" int sigstack(struct sigstack *, struct sigstack *); // missing from signal.h
#endif

#if defined( __sgi__ )
#ifndef sa_sigaction
// fake a few things
#define sa_sigaction sa_handler
#endif
#endif

#if defined( __aix__ ) && defined( __ibm__ )
extern "C" int sigsetmask(int);				// missing from signal.h
extern "C" int sigblock(int);				// missing from signal.h
extern "C" int sigvec(int, struct sigvec *, struct sigvec *);  // missing from signal.h
#endif

#if defined( __hpux__ ) && defined( __hp__ )
extern "C" int sigvec(int, struct sigvec *, struct sigvec *);  // missing from signal.h
#endif

#if defined( __ultrix__ ) && defined( __dec__ )
extern "C" int sigsetmask(int);				// missing from signal.h
extern "C" int sigblock(int);				// missing from signal.h
extern "C" int sigvec(int, struct sigvec *, struct sigvec *);  // missing from signal.h
extern "C" int sigstack(struct sigstack *, struct sigstack *); // missing from signal.h
#endif

#if defined( __linux__ )
// fake a few things
#ifndef sa_sigaction
#define sa_sigaction sa_handler
#endif
#define sc_mask oldmask
#define sc_pc eip
#define sc_sp esp
#ifndef SV_ONSTACK
#define SV_ONSTACK 0
#endif
#endif

#if defined( __gizmo__ )
extern "C" int fprintf(FILE *, const char *, ...);
extern "C" char *strerror(int n);
#endif


// By initializing these variables here, their storage is allocated in this
// object file.

void *uSigHandlerModule::beginUserCode = NULL;
void *uSigHandlerModule::endUserCode = NULL;
#if ( __GNUG__ == 2 && __GNUC_MINOR__ >= 8 )		// gcc releases >= 2.8
void *uSigHandlerModule::beginInlineUserCode = NULL;
void *uSigHandlerModule::endInlineUserCode = NULL;
#endif

static const char *uSignalDescription[] = {
    "process exiting",
    "hangup",
    "interrupt",
    "quit",
    "illegal instruction",
    "trace trap",
    "iot instruction",
    "emt instruction",
    "floating point exception",
    "kill",
    "bus error",
    "segmentation violation",
    "bad argument to system call",
    "write on a pipe with no one to read it",
    "alarm clock",
    "software termination signal",
    "urgent condition present on socket",
    "stop",
    "stop signal generated from keyboard",
    "continue after stop",
    "child status has changed",
    "background read attempted from control terminal",
    "background write attempted to control terminal",
    "io is possible on a descriptor",
    "cpu time limit exceeded",
    "file size limit exceeded",
    "virtual time alarm",
    "profiling timer alarm",
    "user by pci to signal a window size change",
    "user defined signal 1",
    "user defined signal 2",
};


void uSigHandlerModule::uSSignal( int sig, void (*handler)(__U_SIGPARMS__), int flags ) { // name clash with uSignal statement
#if defined( __svr4__ ) || defined( __linux__ )
    struct sigaction act;
    (void *)(act.sa_sigaction) = handler;		// cast because handler type is not consistent
    sigemptyset( &act.sa_mask );
    sigaddset( &act.sa_mask, SIGALRM );			// disable SIGALRM during signal handler
    act.sa_flags = flags;

    if ( sigaction( sig, &act, NULL ) == -1 ) {
#else
    struct sigvec nv;
    (void *)(nv.sv_handler) = handler;			// cast becuase handler type is not consistent
    nv.sv_mask = sigmask( SIGALRM );			// disable SIGALRM during signal handler
    nv.sv_flags = flags;

    if ( sigvec( sig, &nv, (struct sigvec *)0 ) == -1 ) {
#endif __svr4__
	// THE KERNEL IS NOT STARTED SO CALL NO uC++ ROUTINES!
	fprintf( stderr, " uSigHandlerModule::uSSignal( sig:%d, handler:0x%p, flags:%d ), problem installing signal handler, error(%d) %s.\n",
		 sig, handler, flags, errno, strerror( errno ) );
	_exit( -1 );
    } // if
} // uSigHandlerModule::uSSignal


inline void *uSigHandlerModule::uSignalContextPC( __U_SIGCXT__ cxt ) {
#if defined( __svr4__ ) && defined( __sun__ )
    return (void *)((ucontext_t *)cxt)->uc_mcontext.gregs[REG_PC];
#elif defined( __sgi__ )
    return (void *)((ucontext_t *)cxt)->uc_mcontext.gregs[CXT_EPC];
#elif defined( __osf__ ) && defined( __dec__ )
    return (void *)((struct sigcontext *)cxt)->sc_pc;
#elif defined( __ibm__ )
    return (void *)cxt->sc_jmpbuf.jmp_context.iar;
#elif defined( __hp__ ) && ! defined( __hp9000s300 )
    return (void *)cxt->sc_pcoq_head;
#elif defined( __svr4__ ) && defined( __sequent__ )
    return (void *)((ucontext_t *)cxt)->uc_mcontext.gregs[MC_O_EIP];
#elif defined( __linux__ )
    return (void *)cxt.sc_pc;
#else
    return (void *)cxt->sc_pc;
#endif
} // uSigHandlerModule::uSignalContextPC


bool uSigHandlerModule::uInUserCode( __U_SIGCXT__ cxt ) {
    // This routine returns 1 if the SIGALRM arrived while executing user
    // code, and a 0 otherwise.  The place of execution can be determined by
    // querying the sigcontext structure that is passed to the signal handler.

    unsigned long int pc = (unsigned long int)uSignalContextPC( cxt );
    return ( pc > (unsigned long int)beginUserCode && pc < (unsigned long int)endUserCode )
#if ( __GNUG__ == 2 && __GNUC_MINOR__ >= 8 )		// gcc releases >= 2.8
	|| ( pc > (unsigned long int)beginInlineUserCode && pc < (unsigned long int)endInlineUserCode )
#endif
	    ;
} // uSigHandlerModule::uInUserCode


void uSigHandlerModule::uSigChldHandler( __U_SIGTYPE__ ) {
    // This routine handles a SIGCHLD signal.  The signal is delivered as the
    // result of a child process terminating.  If the child process terminates
    // because of some error, the application is terminated.

  if ( uKernelModule::uGlobalAbort ) return;		// close down in progress, ignore signal
    uThisTask().uSetState( uBaseTask::uBlocked );

    pid_t uPid;
    int status;

    for ( ;; ) {
	uPid = ::waitpid( -1, &status, WNOHANG );	// grab the pid of any child and its exit status
      if ( uPid != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for

    if ( uPid == -1 ) {
	uAbort( "uSigHandlerModule::uSigChldHandler, internal error, error(%d): %s", errno, strerror( errno ) );
    } // if
  
#ifdef __U_DEBUG_H__
    char buffer[256];
    uDebugPrtBuf( buffer, "uSigChldHandler, pid:%d, status:0x%p\n", uPid, status );
#endif __U_DEBUG_H__

    // uPid == 0 => an external signal not caused by the child processes.
    // Possibly the shell putting the application into the background.

    if ( uPid != 0 && WIFSIGNALED( status ) ) {		// process died as the result of some signal ?
	// Terminate the application with an appropriate error message.

	uKernelModule::uCoreDumped = true;		// assume that the child dumped core
	uAbort( "child process %d died, cause of death was %s", uPid, uSignalDescription[WTERMSIG( status )] );
    } // if

    uThisTask().uSetState( uBaseTask::uRunning );
} // uSigHandlerModule::uSigChldHandler


void uSigHandlerModule::uSigTermHandler( __U_SIGTYPE__ ) {
    // This routine handles a SIGHUP, SIGINT, or a SIGTERM signal.  The signal
    // is delivered to the root process as the result of some action on the
    // part of the user attempting to terminate the application.  It must be
    // caught here so that all processes in the application may be terminated.

#ifdef __U_DEBUG_H__
    char buffer[256];
    uDebugPrtBuf( buffer, "uSigTermHandler, cluster:0x%p (%s), processor:0x%p\n",
		  &uThisCluster(), uThisCluster().uGetName(), &uThisProcessor() );
#endif __U_DEBUG_H__

  if ( uKernelModule::uGlobalAbort ) _exit( -1 );	// close down in progress, terminate
    // System task detects the interrupt and aborts the program.

    uKernelModule::uTerminate = true;
} // uSigHandlerModule::uSigTermHandler


void uSigHandlerModule::uSigAlrmHandler( __U_SIGPARMS__ ) {
#ifdef __U_DEBUG_H__
    char buffer[256];
#endif __U_DEBUG_H__

    // This routine handles a SIGALRM signal.  This signal is delivered as the
    // result of time slicing being enabled, a processor is being woken up
    // after being idle for some time, or some intervention being delivered to
    // a thread.  This handler attempts to yield the currently executing thread
    // so that another thread may be scheduled by this processor.

  if ( uKernelModule::uGlobalAbort ) return;		// close down in progress, ignore signal
  if ( uKernelModule::uInKernelRF ) return;		// roll-forward flag on ? spurious alarm
    uThisTask().uSetState( uBaseTask::uBlocked );

#ifdef __gizmo__
    // The gizmo OS does not generate a correct sigcontext, so one is
    // manufactured from bits of string and ceiling wax. cxt is copied to
    // prevent any bizarre behaviour when the signal handler ends.

    struct sigcontext gizmoCxt;
    gizmoCxt.sc_onstack = cxt->sc_onstack;		// sigstack state to restore
    gizmoCxt.sc_mask = cxt->sc_mask;			// signal mask to restore
    gizmoCxt.sc_sp = *(((int *)&sig)+171);		// sp to restore
    gizmoCxt.sc_pc = *(((int *)&sig)+174);		// pc to retore
    gizmoCxt.sc_ps = *(((int *)&sig)+173);		// psl to restore
    cxt = &gizmoCxt;
#endif __gizmo__

    if ( uInUserCode( cxt ) && ! uKernelModule::uDisableIntSpin ) {	// executing in user code
	if ( ! uKernelModule::uDisableInt ) {		// and not in kernel ?
#ifdef __U_DEBUG_H__
	    uDebugPrtBuf( buffer, "uSigAlrmHandler1, task:0x%p, stack:0x%p, address:0x%p, user code:%d, uDisableInt:%d, uDisableIntCnt:%d\n",
#ifdef __svr4__
			  &uThisTask(), ((ucontext_t *)cxt)->uc_mcontext.gregs[REG_SP], uSignalContextPC( cxt ), uInUserCode( cxt ),
			  uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt );
#else
	    		  &uThisTask(), cxt->sc_sp, uSignalContextPC( cxt ), uInUserCode( cxt ),
	    		  uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt );
#endif __svr4__
#endif __U_DEBUG_H__

#ifdef __svr4__
	    sigrelse( SIGALRM );			// clear the blocked SIGALRM signal so more can arrive
#else
#if defined( __aix__ ) && defined( __ibm__ )
	    sigsetmask( cxt->sc_mask.losigs );		// clear the blocked SIGALRM signal so more can arrive
#elif defined( __linux__ )
	    sigsetmask( cxt.sc_mask );			// clear the blocked SIGALRM signal so more can arrive
#else
	    sigsetmask( cxt->sc_mask );			// clear the blocked SIGALRM signal so more can arrive
#endif
#endif __svr4__

#ifdef __U_DEBUG__
	    // The current PC is stored, so that it can be looked up by the
	    // local debugger to check if the task was time sliced at a
	    // breakpoint location.

	    uThisTask().DebugPCandSRR = uSignalContextPC( cxt );
#endif __U_DEBUG__

	    uKernelModule::uRollForward();

#ifdef __U_DEBUG__
	    // Reset this field before task is started, to denote that this
	    // task is not blocked.

	    uThisTask().DebugPCandSRR = NULL;
#endif __U_DEBUG__

#ifdef __svr4__
	    sighold( SIGALRM );				// block SIGALRM signal for handler clean up
#else
	    sigblock( sigmask(SIGALRM) );		// block SIGALRM signal for handler clean up
#endif __svr4__
	} else {					// interrupts disabled
#ifdef __U_DEBUG_H__
	    uDebugPrtBuf( buffer, "uSigAlrmHandler2, task:0x%p, stack:0x%p, address:0x%p, user code:%d, uDisableInt:%d, uDisableIntCnt:%d\n",
#ifdef __svr4__
			  &uThisTask(), ((ucontext_t *)cxt)->uc_mcontext.gregs[REG_SP], uSignalContextPC( cxt ), uInUserCode( cxt ),
			  uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt );
#else
	    		  &uThisTask(), cxt->sc_sp, uSignalContextPC( cxt ), uInUserCode( cxt ),
	    		  uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt );
#endif __svr4__
#endif __U_DEBUG_H__
	    uKernelModule::uInKernelRF += 1;
	} // if
    } else {						// in library code
	if ( uKernelModule::uDisableInt && ! uKernelModule::uDisableIntSpin ) { // inside the kernel but not in spinlock
#ifdef __U_DEBUG_H__
	    uDebugPrtBuf( buffer, "uSigAlrmHandler3, task:0x%p, stack:0x%p, address:0x%p, user code:%d, uDisableInt:%d, uDisableIntCnt:%d\n",
#ifdef __svr4__
			  &uThisTask(), ((ucontext_t *)cxt)->uc_mcontext.gregs[REG_SP], uSignalContextPC( cxt ), uInUserCode( cxt ),
			  uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt );
#else
	    		  &uThisTask(), cxt->sc_sp, uSignalContextPC( cxt ), uInUserCode( cxt ),
	    		  uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt );
#endif __svr4__
#endif __U_DEBUG_H__
	    uKernelModule::uInKernelRF += 1;
	} else {
#ifdef __U_DEBUG_H__
	    uDebugPrtBuf( buffer, "uSigAlrmHandler4, task:0x%p, stack:0x%p, address:0x%p, user code:%d, uDisableInt:%d, uDisableIntCnt:%d\n",
#ifdef __svr4__
			  &uThisTask(), ((ucontext_t *)cxt)->uc_mcontext.gregs[REG_SP], uSignalContextPC( cxt ), uInUserCode( cxt ),
			  uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt );
#else
	    		  &uThisTask(), cxt->sc_sp, uSignalContextPC( cxt ), uInUserCode( cxt ),
	    		  uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt );
#endif __svr4__
#endif __U_DEBUG_H__

	    // Bump up the alarm, but not when currently setting the alarm.

	    if ( ! uKernelModule::uSettingTimerRF ) {
		uActiveProcessorKernel->uSetTimer( uDuration( 0, TIMEGRAN / 1000000L ) );
	    } // if
	} // if
    } // if
    uThisTask().uSetState( uBaseTask::uRunning );
} // uSigHandlerModule::uSigAlrmHandler


// When the shared memory mapping is extended, it is extended by one process
// and only that process knows that the mapping has been extended.  Other
// processes attempting to access the extended memory fault causing a SIGSEGV
// or SIGBUS signal. These handlers catchs those signals.  If the address that
// faulted is in the heap, the mapping is extended for that process.
// Otherwise, the old signal handler is restored, which causes the fault to
// occur again and be handled by the standard signal handler.

void uSigHandlerModule::uSigSegvBusHandler( __U_SIGPARMS__ ) {
    uThisTask().uSetState( uBaseTask::uBlocked );
#ifdef __U_MULTI__
    void *temp = uMemoryModule::uCheckAndMap();
    if ( temp == NULL )	// NO BRACE!!!
#endif __U_MULTI__
	uAbort( "attempt to address location 0x%p.\n"
	       "Possible cause is reading outside the address space or writing to a protected area within the address space with an invalid pointer.",
#ifdef __svr4__
	        sfp->si_addr );
#elif defined( __linux__ )
		NULL );
#else
		addr );
#endif __svr4__
    uThisTask().uSetState( uBaseTask::uRunning );
} // uSigHandlerModule::uSigSegvBusHandler


uSigHandlerModule::uSigHandlerModule() {
    beginUserCode = uMachContext::uRtnAdr( uKernelModule::uBeginUserCode );
    endUserCode = uMachContext::uRtnAdr( uKernelModule::uEndUserCode );
#if ( __GNUG__ == 2 && __GNUC_MINOR__ >= 8 )		// gcc releases >= 2.8
    beginInlineUserCode = uMachContext::uRtnAdr( uKernelModule::uBeginInlineUserCode );
    endInlineUserCode = uMachContext::uRtnAdr( uKernelModule::uEndInlineUserCode );
#endif

    // Associate handlers with the set of signals that this application is
    // interested in.  These handlers are inherited by all unix processes that
    // are subsequently created so they need not be installed again.

    uSSignal( SIGCHLD, uSigChldHandler );
#ifdef __svr4__
    // Do NOT specify SA_RESTART for SIGALRM because "select" does not wake up
    // when sent a SIGALRM from another UNIX process, which means non-blocking
    // I/O does not work correctly in multiprocessor mode.

    uSSignal( SIGALRM, uSigAlrmHandler, SA_SIGINFO );
    uSSignal( SIGHUP,  uSigTermHandler, SA_SIGINFO );
    uSSignal( SIGINT,  uSigTermHandler, SA_SIGINFO );
    uSSignal( SIGTERM, uSigTermHandler, SA_SIGINFO );
    uSSignal( SIGSEGV, uSigSegvBusHandler, SA_SIGINFO );
    uSSignal( SIGBUS,  uSigSegvBusHandler, SA_SIGINFO );
#else
    uSSignal( SIGALRM, uSigAlrmHandler );
    uSSignal( SIGHUP,  uSigTermHandler );
    uSSignal( SIGINT,  uSigTermHandler );
    uSSignal( SIGTERM, uSigTermHandler );
    uSSignal( SIGSEGV, uSigSegvBusHandler );
    uSSignal( SIGBUS,  uSigSegvBusHandler );
#endif __svr4__
} // uSigHandlerModule::uSigHandlerModule


// Local Variables: //
// compile-command: "dmake" //
// End: //
