//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uProcessor.h -- 
// 
// Author           : Peter Buhr
// Created On       : Thu May 26 09:36:12 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Aug  6 23:01:42 1996
// Update Count     : 14
// 


#ifndef __U_PROCESSOR_H__
#define __U_PROCESSOR_H__


//######################### uProcessorTask #########################


uTask uProcessorTask {
    friend class uProcessor;				// access: uFork, uSetPreemption

    uCondition uResult, uResponse;

    int uPreemption;					// communication: uSetPreemption
    uProcessor *uNewProc;				// communication: uFork
    void *uBegin;					// communication: uMmap
    int uSize;
    int uProt;
    int uFlags;
    int uFd;
    int uOff;
    void *uAddr;
    uCluster *uClus;					// communication: uSetCluster

    void main();
    uMutex void uSetPreemption( int ms );
    uMutex void uFork( uProcessor *np );
    uMutex void *uMmap( void *begin, int size, int prot, int flags, int fd, int off );
    uMutex void uSetCluster( uCluster &clus );

    uProcessorTask( uCluster &uClus, uProcessor &uProc );
    ~uProcessorTask();
  public:
};


#endif __U_PROCESSOR_H__


// Local Variables:
// compile-command: "dmake"
// End:
