//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
// 
// uPrivate.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Fri Dec 17 17:31:41 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Oct 27 11:03:10 1998
// Update Count     : 140
// 


#define __U_KERNEL__
#include <uC++.h>

// These "magic" variables are placed at the beginning of the .data section to
// allow a program's .data and .bss to be mapped to a file so that it can be
// shared by all child processes. This file is presented to the loader first.


// By initializing these variables here, their storage is allocated in this
// object file.

#if ! defined( __gizmo__ ) && ! defined( __ibm__ )	// TEMPORARY, why is this necessary for AIX ?
int		errno				= 0;	// errno must be private to each UNIX process.
#endif

uProcessor	*uKernelModule::uActiveProcessor= &(((uIOCluster *)&uSystemClusterStorage)->processor);
uCluster	*uKernelModule::uActiveCluster	= (uIOCluster *)&uSystemClusterStorage;
uBaseTask	*uKernelModule::uActiveTask	= (uBaseTask *)&uTaskBootStorage;

bool		uKernelModule::uDisableInt	= true;
unsigned int	uKernelModule::uDisableIntCnt	= 1;

bool            uKernelModule::uDisableIntSpin	= false;
unsigned int	uKernelModule::uDisableIntSpinCnt = 0;

unsigned int	uKernelModule::uInKernelRF	= 0;
bool            uKernelModule::uSettingTimerRF	= false;

char		*uKernelModule::uMyProgramFileEnd = (char *)-1;
double		uKernelModule::uProcessorKernelStorage[(sizeof(uProcessorKernel) + sizeof(double)) / sizeof(double)] = {0.0};
double		uKernelModule::uProcessorKernelStack[(__U_DEFAULT_STACK_SIZE__ + sizeof(double)) / sizeof(double)] = {0.0};

// uMappingBuffer *MUST* be the last declaration in this file.
char		uKernelModule::uMappingBuffer[__U_PAGE_SIZE__] = "";


// Local Variables: //
// compile-command: "dmake" //
// End: //
