//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
// 
// uPageSize.cc -- Generate a manifest constant of the page size for use in
//        subsequent compilation of kernel code.
// 
// Author           : Peter Buhr
// Created On       : Sat Dec 18 22:12:20 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Oct 19 17:40:05 1998
// Update Count     : 20
// 


#include <iostream.h>
#if defined( __svr4__ ) || ( __GNUG__ == 2 && __GNUC_MINOR__ >= 8 ) // releases >= 2.8
#include <unistd.h>
#else
#include <getpagesize.h>
#endif

#if defined( __svr4__ ) && defined( __sun__ )
#ifndef _SC_PAGE_SIZE
#define _SC_PAGE_SIZE _SC_PAGESIZE
#endif
#endif

#if defined( __sgi__ )
#ifndef _SC_PAGE_SIZE
#define _SC_PAGE_SIZE _SC_PAGESIZE
#endif
#endif

int main() {
    cout << "// file generated at installation time by uPageSize.cc" << endl;
    cout << endl;
    cout << "#ifndef __U_PAGE_SIZE_H__" << endl;
    cout << "#define __U_PAGE_SIZE_H__" << endl;
    cout << endl;
#if defined( __svr4__ ) || ( __GNUG__ == 2 && __GNUC_MINOR__ >= 8 ) // releases >= 2.8
    cout << "#define __U_PAGE_SIZE__ " << sysconf( _SC_PAGE_SIZE ) << "" << endl;
#else
    cout << "#define __U_PAGE_SIZE__ " << getpagesize() << "" << endl;
#endif __svr4__
    cout << endl;
    cout << "static inline int uPageSize() {" << endl;
    cout << "    return __U_PAGE_SIZE__;" << endl;
    cout << "} // uPageSize" << endl;
    cout << endl;
    cout << "#endif" << endl;
    return 0;						// otherwise "make" stops!
} // main


// Local Variables:
// compile-command: "dmake"
// End:
