//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
// 
// uMemory.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sat Dec 18 10:28:47 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Mar 19 21:27:54 1999
// Update Count     : 358
// 

#define __U_KERNEL__
#include <uC++.h>
#include <uBootTask.h>
#include <uPageSize.h>
//#include <uDebug.h>


#include <string.h>					// strerror
#include <stdio.h>					// FILENAME_MAX
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <sys/mman.h>


#ifndef FILENAME_MAX
#define FILENAME_MAX 1024
#endif

#if ! defined( __svr4__ ) && defined( __sun__ )
extern "C" int ftruncate(int, off_t);			// missing from sys/types.h
extern "C" int munmap(caddr_t, int);			// missing from sys/mman.h
extern "C" int getrlimit(int, struct rlimit *);		// missing from sys/resources.h
extern "C" int setrlimit(int, struct rlimit *);		// missing from sys/resources.h
#endif

#if defined( __aix__ ) && defined( __ibm__ )
extern "C" int getrlimit(int, struct rlimit *);		// missing from sys/resources.h
#endif

#if defined( __hpux__ ) && defined( __hp__ )
#define	RLIMIT_DATA	2				// missing from sys/resources.h
#endif

#if defined( __ultrix__ ) && defined( __dec__ )
extern "C" int ftruncate(int, off_t);			// missing from sys/types.h
extern "C" caddr_t mmap(caddr_t, size_t, int, int, int, off_t); // missing from sys/mman.h
extern "C" int munmap(caddr_t, size_t);			// missing from sys/mman.h
extern "C" int getrlimit(int, struct rlimit *);		// missing from sys/resources.h
#endif

#if defined( __gizmo__ )
extern "C" int fprintf(FILE *, const char *, ...);
extern "C" char *strerror(int n);
#endif


// This magic variable marks the end of the .bss. sbrk cannot be used to find
// the end of the .bss because it is redefined.

#if defined( __sun__ ) && defined( __svr4__ )
#define U_END _end
#else
#define U_END end
#endif

extern int U_END;					// end of .bss


// By initializing these variables here, their storage is allocated in this
// object file.

int uMemoryModule::uProgramFile = 0;
char *uMemoryModule::uProgramFileBegin = 0;
char *uMemoryModule::uProgramFileEnd = 0;
uSpinLock *uMemoryModule::uMapLock = 0;


#ifdef __U_MULTI__
// Generate temporary file name *without* calling malloc because it is used in
// uMemoryInit *before* the heap is initialized. Not thread safe. :-)

static char *uTmpnam() {
    static char name[FILENAME_MAX];
    static int cnt = 0;

    cnt += 1;						// unique numbering per application

    char *tmpdir = getenv( "TMPDIR" );
    if ( tmpdir == (char *)0 ) {			// check for environment variable
	tmpdir = TMPDIR;				// use default
    } // if

    strcpy( name, tmpdir );
    if ( tmpdir[strlen( tmpdir ) - 1] != '/' ) {	// trailing slash ?
	strcat( name, "/" );				// add slash
    } // if

    strcat( name, "uC++" );				// add prefix
    sprintf( &name[strlen(name)], "%.3d%.6ld", cnt, getpid() ); // add unique qualifies
    return name;
} // uTmpnam
#endif __U_MULTI__


static inline void *uMmap( void *begin, size_t size, int prot, int flags, int fd, int off ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "uMmap( begin:0x%p, size:0x%x, prot:0x%x, flags:0x%x, fd:%d, off:0x%x )\n", begin, size, prot, flags, fd, off );
#endif __U_DEBUG_H__

    void *addr = ::mmap( (caddr_t)begin, size, prot, flags, fd, off );
    if ( addr == (void *)-1 ) {
	uAbort( "uMmap( begin:0x%p, size:%d, prot:0x%p, flags:0x%p, fd:0x%p, off:%d ): could not map region, error(%d) %s.",
	        begin, size, prot, flags, fd, off, errno, strerror( errno) );
    } // if

#ifdef __U_DEBUG_H__
    uDebugPrt( "uMmap, addr:0x%p\n", addr );
#endif __U_DEBUG_H__

    return addr;
} // uMmap


static inline void uFtruncate( int fd, int size ) {
    // Some systems requires the file to be truncated to the required length
    // before it is mapped because "mmap cannot be used to implicitly extend
    // the length of files".

#ifdef __U_DEBUG_H__
    uDebugPrt( "uFtruncate( fd:%d, size:0x%x (%d) )\n", fd, size, size );
#endif __U_DEBUG_H__
    int code;
    
    for ( ;; ) {
	code = ::ftruncate( fd, size );
      if ( code != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    if ( code == -1 ) {
	uAbort( "uFtruncate( fd:%d, size:%d ): could not truncate file, error(%d) %s.",
	        fd, size, errno, strerror( errno ) );
    } // if
} // uFtruncate


inline void *uMemoryModule::uDoCheckAndMap() {
#ifdef __U_DEBUG_H__
    uDebugPrt( "uMemoryModule::uDoCheckAndMap(), uMyProgramFileEnd:0x%p, uProgramFileEnd:0x%p\n", uKernelModule::uMyProgramFileEnd, uProgramFileEnd );
#endif __U_DEBUG_H__

    if ( uKernelModule::uMyProgramFileEnd != uProgramFileEnd ) { // is this process consistent with global view ?
	char *begin, *end;

	if ( uProgramFileEnd > uKernelModule::uMyProgramFileEnd ) { // make heap larger or smaller ?
	    begin = uKernelModule::uMyProgramFileEnd;
	    end = uProgramFileEnd;

	    uMmap( begin, end - begin, PROT_READ | PROT_WRITE, MAP_SHARED | MAP_FIXED, uProgramFile, begin - uProgramFileBegin );
	} else {
	    begin = uProgramFileEnd;
	    end = uKernelModule::uMyProgramFileEnd;

	    if ( munmap( begin, end - begin ) == -1 ) {
		uAbort( "uMemoryModule::uDoCheckAndMap(): could not unmap region, error(%d) %s.",
		        errno, strerror( errno ) );
	    } // if
	} // if

	uKernelModule::uMyProgramFileEnd = uProgramFileEnd;
	return uKernelModule::uMyProgramFileEnd;
    } else {
	return NULL;
    } // if
} // uMemoryModule::uDoCheckAndMap


#if ! defined( __svr4__ ) && defined( __U_MULTI__ )
void *_curbrk = NULL;				// seems to be used on BSD systems
#endif

void *uMemoryModule::uDoSbrk( int size ) {
#ifdef __U_DEBUG__
    if ( uKernelModule::uMyProgramFileEnd == (char *)-1 ) {
	// THE KERNEL IS NOT STARTED SO CALL NO uC++ ROUTINES!
	fprintf( stderr, "uMemoryModule::uDoSbrk( %d ): called before memory mapping initialized; make sure include file <uC++.h> "
	         "appears first in all source files\n", size );
	_exit( -1 );
    } // if
#endif __U_DEBUG__

    uCSpinLock uDummy( *uMapLock );

    char *begin, *end;

#ifdef __U_DEBUG_H__
    uDebugPrt( "uMemoryModule::uDoSbrk( size:0x%p )\n", size );
#endif __U_DEBUG_H__

    // Before extending the address space, ensure that this process's mapping
    // is up-to-date or holes appear in the mapping before this new extension.

    uDoCheckAndMap();

    if ( size > 0 ) {					// make heap larger or smaller ?
	begin = uProgramFileEnd;
	end = uProgramFileEnd + size;

	struct rlimit rlim;
	getrlimit( RLIMIT_DATA, &rlim );
#ifdef __U_DEBUG_H__
	uDebugPrt( "uMemoryModule::uDoSbrk, RLIMIT_DATA, rlim_cur:0x%p, rlim_max:0x%p\n", rlim.rlim_cur, rlim.rlim_max );
#endif __U_DEBUG_H__
	if ( size > rlim.rlim_cur ) {			// made heap too large ?
	    errno = ENOMEM;
	    return (void *)-1;
	} // if

	uFtruncate( uProgramFile, end - uProgramFileBegin );
	uMmap( begin, size, PROT_READ | PROT_WRITE, MAP_SHARED | MAP_FIXED, uProgramFile, begin - uProgramFileBegin );
    } else if ( size < 0 ) {
	begin = uProgramFileEnd + size;
	end = uProgramFileEnd;

	if ( begin < uProgramFileBegin ) {		// made heap too small ?
	    errno = ENOMEM;
	    return (void *)-1;
	} // if

	uFtruncate( uProgramFile, begin - uProgramFileBegin );
	if ( munmap( begin, end - begin ) == -1 ) {
	    uAbort( "uMemoryModule::uDoSbrk( size:%d ): could not unmap region, error(%d) %s.",
		    size, errno, strerror( errno ) );
	} // if
    } else {						// mmap and munmap do not like 0 size
	end = uProgramFileEnd;
    } // if

    void *oldend = uProgramFileEnd;
    uKernelModule::uMyProgramFileEnd = uProgramFileEnd = end;
#if ! defined( __svr4__ ) && defined( __U_MULTI__ )
    _curbrk = end;					// seems to be used on BSD systems
#endif

#ifdef __U_DEBUG_H__
    uDebugPrt( "uMemoryModule::uDoSbrk, uProgramFileBegin:0x%p, uProgramFileEnd:0x%p, returns:0x%p\n", uProgramFileBegin, uProgramFileEnd, oldend );
#endif __U_DEBUG_H__

    return oldend;
} // uMemoryModule::uDoSbrk


void *uMemoryModule::uCheckAndMap() {
    uCSpinLock uDummy( *uMapLock );			// mutual exclusion

    return uDoCheckAndMap();
} // uCheckAndMap


#define uStackMaxSize (512 * 1024)
#define uStackBlockSize (64 * 1024)

void uMemoryModule::uStackInit() {
#ifdef __U_MULTI__
    // The kernel should be running now and be in the boot sequence.

    char *tmpfile = uTmpnam();

    int stackfd = ::open( tmpfile, O_CREAT | O_RDWR, 0660 );
    if ( stackfd == -1 ) {
	uAbort( "uMemoryModule::uStackInit, unable to open temporary file %s, error(%d) %s.",
	        tmpfile, errno, strerror( errno ) );
    } // if

    if ( ::unlink( tmpfile ) == -1 ) {
	uAbort( "uMemoryModule::uStackInit, could not unlink file %s, error(%d) %s.",
	        tmpfile, errno, strerror( errno ) );
    } // if

    uFtruncate( stackfd, uStackMaxSize );

    struct rlimit rlim;
    getrlimit( RLIMIT_STACK, &rlim );
    rlim.rlim_cur = uStackMaxSize;
    setrlimit( RLIMIT_STACK, &rlim );

    // The starting location of the stack is machine specific, and there does
    // not seem to be a programmatic way to determine the starting location of
    // the stack. As well, the loader does not seem to allow setting the stack
    // starting location. As result, these explicit constants have to be used.

#if defined( __sun__ ) && defined( __sparc__ )
    // Different versions of Sun OS seem to start the stack at different
    // locations, which is a pain. The following hack seems to work.

    // 0xf0000000 on SunOS 4.1.x 2 and 0xf8000000 on SunOS 4.1.x 1
    void *uStackBase = (void *)(uCeiling( (long unsigned int)uKernelModule::uTaskBoot->uSP, 0x1000000 ));
#elif defined( __sun__ ) && defined( __m68k__ )
    void *uStackBase = (void *)0xe000000;
#elif defined( __sgi__ ) && defined( __mips__ )
    void *uStackBase = (void *)0x80000000;
#elif defined( __dec__ ) && defined( __alpha__ )
    void *uStackBase = (void *)0x120000000;
#elif defined( __linux__ ) && defined( __i386__ )
    void *uStackBase = (void *)0xc0000000;
#elif defined( __svr4__ ) && defined( __i386__ )
    void *uStackBase = (void *)0x08048000;
#endif
    void *uStackLimit = (char *)uStackBase - uStackMaxSize;

    void *uStackCurr = uKernelModule::uTaskBoot->uSP;
    ptrdiff_t size = (char *)uStackBase - (char *)uStackCurr;
#ifdef __U_DEBUG_H__
    uDebugPrt( "uMemoryModule::uStackInit, uKernelModule::uTaskBoot->uSP:0x%p, uStackBase:0x%p, uStackLimit:0x%p, uStackCurr:0x%p, size:0x%p\n",
	       uKernelModule::uTaskBoot->uSP, uStackBase, uStackLimit, uStackCurr, size );
    uDebugPrt( "uMemoryModule::uStackInit, seeking to:0x%p\n", uStackMaxSize - size );
#endif __U_DEBUG_H__
    lseek( stackfd, uStackMaxSize - size, SEEK_SET );

    int count, bytes;
    for ( count = 0; count < size; count += bytes ) {
#ifdef __U_DEBUG_H__
	uDebugPrt( "uMemoryModule::uStackInit, writing from:0x%p for:0x%p\n", (char *)uStackCurr + count, size - count );
#endif __U_DEBUG_H__
	bytes = ::write( stackfd, (char *)uStackCurr + count, size - count );
	if ( bytes == -1 ) {
	    uAbort( "uMemoryModule::uStackInit, write failure to %s, error(%d) %s.",
		    tmpfile, errno, strerror( errno ) );
	} // if
    } // for

    uMmap( uStackLimit, uStackMaxSize, PROT_READ | PROT_WRITE, MAP_SHARED | MAP_FIXED, stackfd, 0 );
#endif __U_MULTI__
} // uMemoryModule::uStackInit


void uMemoryModule::uMemoryInit() {
#ifdef __U_MULTI__
    // THE KERNEL IS NOT STARTED SO CALL NO uC++ ROUTINES!

    // Initialize the lock that protects memory management.

    static double uMapLockStorage[(sizeof(uSpinLock) + sizeof(double)) / sizeof(double)];
    uMemoryModule::uMapLock = new((void *)&uMapLockStorage) uSpinLock; // destructor never invoked

    // This technique relies on initialized data being laid out in the
    // following order in memory: uPrivate, all other initialized and
    // uninitialized data. This order is provided by presenting the loader with
    // the initialized data in the correct order in the load stream. Whether
    // all loaders preserve this order remains to be seen. Data with higher
    // addresses than uMappingBuffer are mapped so that they are shared by all
    // UNIX processes. Non-mapped data is not shared and allows each UNIX
    // process to have private variables at a fixed location.

    char *tmpfile = uTmpnam();

    uProgramFile = ::open( tmpfile, O_CREAT | O_RDWR, 0660 );
    if ( uProgramFile == -1 ) {
	fprintf( stderr, "uMemoryModule::uMemoryInit(), could not open temporary file %s, error(%d) %s.\n",
		 tmpfile, errno, strerror( errno ) );
	_exit( -1 );
    } // if

    // Remove the file from the directory so that its resources are
    // automatically cleaned up when the program terminates.

    if ( ::unlink( tmpfile ) == -1 ) {
	fprintf( stderr, "uMemoryModule::uMemoryInit(), could not unlink file %s, error(%d) %s.\n",
		 tmpfile, errno, strerror( errno ) );
	_exit( -1 );
    } // if

    // Map all data except the private data into the shared area.  Unmapped data
    // is private by definition (separate address space from UNIX fork).

    uProgramFileBegin = (char *)uCeiling( (long unsigned int)&uKernelModule::uMappingBuffer, uPageSize() );
    uKernelModule::uMyProgramFileEnd = uProgramFileEnd = (char *)uCeiling( (long unsigned int)&U_END, uPageSize() );
    ptrdiff_t size = uProgramFileEnd - uProgramFileBegin;

#ifdef __U_DEBUG_H__
    fprintf( stderr, "(%d) uMemoryModule::uMemoryInit, uProgramFileBegin:0x%p, stage1:0x%p, size1:%d \n",
	     getpid(), uProgramFileBegin, uProgramFileEnd, size );
#endif __U_DEBUG_H__

    // Write the current contents of data memory to the file, which is then
    // mapped back. The uninitialized data must be written as well as the
    // initialized data because C requires that uninitialized data be zero
    // filled.

    int count, bytes;
    for ( count = 0; count < size; count += bytes ) {
#ifdef __U_DEBUG_H__
	fprintf( stderr, "(%d) uMemoryModule::uMemoryInit, file:%d, start:0x%p, size:%d \n",
		getpid(), uProgramFile, uProgramFileBegin + count, size - count );
#endif __U_DEBUG_H__
	bytes = ::write( uProgramFile, uProgramFileBegin + count, size - count );
	if ( bytes == -1 ) {
	    fprintf( stderr, "uMemoryModule::uMemoryInit(), write failure to %s, error(%d) %s.\n",
		     tmpfile, errno, strerror( errno ) );
	    _exit( -1 );
	} // if
    } // for

    // Now map the file back into memory.  (Don't call uMmap as it may contain
    // protected debug statements.)

#ifdef __U_DEBUG_H__
    fprintf( stderr, "(%d) uMemoryModule::uMemoryInit, mmap( begin:0x%p, size:0x%x, prot:0x%x, flags:0x%x, fd:%d, off:0x%x )\n",
	     getpid(), uProgramFileBegin, size, PROT_READ | PROT_WRITE, MAP_SHARED | MAP_FIXED, uProgramFile, 0 );
#endif __U_DEBUG_H__
    void *addr = ::mmap( (caddr_t)uProgramFileBegin, size, PROT_READ | PROT_WRITE, MAP_SHARED | MAP_FIXED, uProgramFile, 0 );
    if ( addr == (void *)-1 ) {
	fprintf( stderr, "uMemoryModule::uMemoryInit(), could not map program file back to memory, error(%d) %s.\n",
		 errno, strerror( errno) );
	_exit( -1 );
    } // if
#endif __U_MULTI__
} // uMemoryModule::uMemoryInit


// replace the libc versions of sbrk and brk

#ifdef __U_MULTI__
extern "C" {
__U_SBRKTYPE__ {
    if ( uMemoryModule::uMapLock == (uSpinLock *)0 ) {
	uMemoryModule::uMemoryInit();
    } // if

    // All memory extensions must be a multiple of the page size.

    void *area = uMemoryModule::uDoSbrk( uCeiling( size, uPageSize() ) );
#ifdef __U_DEBUG_H__
    uDebugPrt( "0x%p = sbrk( %d )\n", area, size );
#endif __U_DEBUG_H__
    return area; 
} // sbrk


__U_BRKTYPE__ {
    if ( uMemoryModule::uMapLock == (uSpinLock *)0 ) {
	uMemoryModule::uMemoryInit();
    } // if

    void *area = uMemoryModule::uDoSbrk( (char *)endds - uMemoryModule::uProgramFileEnd );
#ifdef __U_DEBUG_H__
    uDebugPrt( "0x%p = brk( 0x%p )\n", area, endds );
#endif __U_DEBUG_H__
    return 0;
} // brk
} // extern "C"
#endif __U_MULTI__


// Local Variables: //
// compile-command: "dmake" //
// End: //
