//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uHeap.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Jul 20 00:07:05 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 11 17:58:48 1998
// Update Count     : 47
// 


#ifndef __U_HEAP_H__
#define __U_HEAP_H__


bool uTraceHeapOn();
bool uTraceHeapOff();
bool uStrictHeapOn();
bool uStrictHeapOff();


class uHeap {						// monitor
    friend bool uTraceHeapOn();				// access: uTraceAlloc
    friend bool uTraceHeapOff();			// access: uTraceAlloc
    friend bool uStrictHeapOn();			// access: uStrict
    friend bool uStrictHeapOff();			// access: uStrict
    friend class uKernelBoot;				// access: uHeap
    friend void *malloc( size_t size );			// access: new
    friend void *realloc( void *addr, size_t size );	// access: new
    friend void *calloc( size_t noOfElems, size_t elemSize ); // access: new
    friend class uXlibBoot;				// access: uStrict

    struct uStorage;					// forward declaration

    struct uSizeHeader {
	size_t blockSize;
	uSpinLock lock;
	uStorage *freeList;
    }; // uSizeHeader

    struct uStorage {
	union uHeader {					// header
	    double uDummy;				// alignment requirement
	    uSizeHeader *home;				// allocated block points back to home locations
	    uStorage *next;				// freed block points next freed block of same size
	} uHdr;
	char uData[0];					// storage
    }; // uStorage

    // These variables are protected by individual locks in the elements.
    uSizeHeader headers[32];
    // These variables are protected by the monitor mutex.
    void *uHeapBegin;					// start of heap
    void *uHeapEnd;					// logical end of heap
    size_t uHeapRemaining;				// amount of storage not allocated in the current chunk

    static bool uTraceAlloc;				// trace allocations and deallocations
    static bool uStrict;				// TEMPORARY: incorrect frees in motif

    size_t uUserSize( void *user );
    uMutex void *uExtend( size_t size );
    void uDoFree( void *addr );
    void *uDoMalloc( size_t size );
    uHeap();
    ~uHeap();

    void *operator new( size_t, void *storage ) { return storage; }
    void *operator new( size_t size ) { return ::operator new( size ); }
  public:
    void *uMalloc( size_t size );
    void *uRealloc( void *addr, size_t size );
    void *uCalloc( size_t noOfElems, size_t elemSize );
    void uFree( void *addr );
    void uCfree( void *addr );
}; // uHeap


#endif __U_HEAP_H__


// Local Variables:
// compile-command: "dmake"
// End:
