//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uFloat.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Oct 10 08:30:46 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Aug 22 22:09:31 1995
// Update Count     : 12
// 


#define __U_KERNEL__
#include <uC++.h>


// Routine that saves the floating point context.

void uFloatingPointContext::uSave() {
    
#ifdef __i386__
    asm volatile ( "fsave (%0)" : : "r" (&uFloatingPointData) );
#endif __i386__
    
#if defined( __m68k__ ) && defined( __HAVE_68881__ )
    // store floating registers fp0-fp7, may be 12 byte extended precision
    
    asm volatile ( "fmovem #0xff,%0@" : : "a" (&uFloatingPointData) );
#endif __m68k__ && __HAVE_68881__

#ifdef __sparc__
    // saved with integer registers
#endif __sparc__

#ifdef __mips__
    asm volatile ( "s.d $f20,0(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "s.d $f22,8(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "s.d $f24,16(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "s.d $f26,24(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "s.d $f28,32(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "s.d $f30,40(%0)" : : "r" (&uFloatingPointData) );
#endif __mips__

#ifdef __alpha__
    asm volatile ( "stt $f2,0(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stt $f3,8(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stt $f4,16(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "stt $f5,24(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "stt $f6,32(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "stt $f7,40(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "stt $f8,48(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "stt $f9,56(%0)" : : "r" (&uFloatingPointData) );
#endif __alpha__
    
#ifdef __rs6000__
    // store floating registers 14-31
    
    asm volatile ( "stfd 14,0(%0)"   : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 15,8(%0)"   : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 16,16(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 17,24(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 18,32(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 19,40(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 20,48(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 21,56(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 22,64(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 23,72(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 24,80(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 25,88(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 26,96(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 27,104(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 28,112(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 29,120(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 30,128(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "stfd 31,136(%0)" : : "r" (&uFloatingPointData) );
#endif __rs6000__

#ifdef __hppa__
    // saved with integer registers
#endif __hppa__
    
} // uFloatingPointContext::uSave


// Routine that restores the floating point context.

void uFloatingPointContext::uRestore() {
    
#ifdef __i386__
    asm volatile ( "frstor (%0)" : : "r" (&uFloatingPointData) );
#endif __i386__
    
#if defined( __m68k__ ) && defined( __HAVE_68881__ )
    // restore floating registers fp0-fp7, may be 12 byte extended precision

    asm volatile ( "fmovem %0@,#0xff" : : "a" (&uFloatingPointData) );
#endif __m68k__ && __HAVE_68881__

#ifdef __sparc__
    // restored with integer registers
#endif __sparc__
    
#ifdef __mips__
    asm volatile ( "l.d $f20,0(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "l.d $f22,8(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "l.d $f24,16(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "l.d $f26,24(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "l.d $f28,32(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "l.d $f30,40(%0)" : : "r" (&uFloatingPointData) );
#endif __mips__

#ifdef __alpha__
    asm volatile ( "ldt $f2,0(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "ldt $f3,8(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "ldt $f4,16(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "ldt $f5,24(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "ldt $f6,32(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "ldt $f7,40(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "ldt $f8,48(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "ldt $f9,56(%0)" : : "r" (&uFloatingPointData) );
#endif __alpha__

#ifdef __rs6000__
    // restore floating registers 14-31
    
    asm volatile ( "lfd 14,0(%0)"   : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 15,8(%0)"   : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 16,16(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 17,24(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 18,32(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 19,40(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 20,48(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 21,56(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 22,64(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 23,72(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 24,80(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 25,88(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 26,96(%0)"  : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 27,104(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 28,112(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 29,120(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 30,128(%0)" : : "r" (&uFloatingPointData) );
    asm volatile ( "lfd 31,136(%0)" : : "r" (&uFloatingPointData) );
#endif __rs6000__

#ifdef __hppa__
    // restored with integer registers
#endif __hppa__

} // uFloatingPointContext::uRestore


// Local Variables: //
// compile-command: "dmake" //
// End: //
