#if ( __GNUG__ == 2 && __GNUC_MINOR__ < 8 )		// gcc releases < 2.8
//#include <uC++.h>
//#include <uDebug.h>

// Copyright (C) 1989, 1992, 1993, 1994, 1995 Free Software Foundation, Inc.
// copied from gcc-2.7.2.1 libgcc2.c

// The static variables except_table_pos, except_pc, and exception_table_list
// were made external so that they could be saved in a context switch, which
// makes exceptions specific to a thread stack.

// Also, small changes were made to allow compilation by g++.

#include <stdlib.h>					// prototype: malloc

typedef struct {
    void *start;
    void *end;
    void *exception_handler;
} exception_table;

struct exception_table_node {
    exception_table *table;
    void *start;
    void *end;
    struct exception_table_node *next;
};

static int except_table_pos;
static void *except_pc;
static struct exception_table_node *exception_table_list;

int uRegisterCnt = 0;

static exception_table *
find_exception_table (void *pc)
{
    register struct exception_table_node *table = exception_table_list;

#ifdef __U_DEBUG_H__
    uDebugPrt("find_exception_table( pc:0x%p ), table:0x%p task 0x%p (%s)\n", pc, table, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__

    for ( ; table != 0; table = table->next) {
	if (table->start <= pc && table->end > pc) {
#ifdef __U_DEBUG_H__
	    uDebugPrt("find_exception_table( pc:0x%p ), exit:0x%p, task 0x%p (%s)\n", pc, table->table, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__
	    return table->table;
	}
    }
#ifdef __U_DEBUG_H__
    uDebugPrt("find_exception_table( pc:0x%p ), exit:NULL, task 0x%p (%s)\n", pc, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__
    return 0;
}

/* this routine takes a pc, and the address of the exception handler associated
   with the closest exception table handler entry associated with that PC,
   or 0 if there are no table entries the PC fits in.  The algorithm works
   something like this:

    while(current_entry exists) {
        if(current_entry.start < pc )
            current_entry = next_entry;
        else {
            if(prev_entry.start <= pc && prev_entry.end > pc) {
                save pointer to prev_entry;
                return prev_entry.exception_handler;
             }
            else return 0;
         }
     }
    return 0;

   Assuming a correctly sorted table (ascending order) this routine should
   return the tightest match...

   In the advent of a tie, we have to give the last entry, as it represents
   an inner block.
 */


extern "C"
void *
__find_first_exception_table_match(void *pc)
{
    exception_table *table = find_exception_table (pc);
    int pos = 0;
    int best = 0;

#ifdef __U_DEBUG_H__
    uDebugPrt("__find_first_exception_table_match( pc:0x%p ), exception_table_list:0x%p, eh_pc:0x%p, eh_type:0x%p, eh_value:0x%p, table:0x%p, task 0x%p (%s)\n",
	      pc, exception_table_list, __eh_pc, __eh_type, __eh_value, table, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__

    if (table == 0) {
#ifdef __U_DEBUG_H__
	uDebugPrt("__find_first_exception_table_match( pc:0x%p ), exit:NULL, task 0x%p (%s)\n", pc, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__
	return (void*)0;
    }

    except_pc = pc;

#if 0
    /* We can't do this yet, as we don't know that the table is sorted.  */
    do {
	++pos;
	if (table[pos].start > except_pc)
	    /* found the first table[pos].start > except_pc, so the previous
	       entry better be the one we want! */
	    break;
    } while(table[pos].exception_handler != (void*)-1);

    --pos;
    if (table[pos].start <= except_pc && table[pos].end > except_pc)
	{
	    except_table_pos = pos;
#if 0
	    printf("__find_first_exception_table_match(): found match: %x\n",table[pos].exception_handler);
#endif
	    return table[pos].exception_handler;
	}
#else
    while (table[++pos].exception_handler != (void*)-1) {
	if (table[pos].start <= pc && table[pos].end > pc)
	    {
		/* This can apply.  Make sure it is better or as good as the previous
		   best.  */
		/* The best one ends first. */
		if (best == 0 || (table[pos].end <= table[best].end
				  /* The best one starts last.  */
				  && table[pos].start >= table[best].start))
		    best = pos;
	    }
    }
    if (best != 0) {
#ifdef __U_DEBUG_H__
	uDebugPrt("__find_first_exception_table_match( pc:0x%p ), exit:0x%p, task 0x%p (%s)\n", pc, table[best].exception_handler, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__
	return table[best].exception_handler;
    }
#endif

#ifdef __U_DEBUG_H__
    uDebugPrt("__find_first_exception_table_match( pc:0x%p ), exit:NULL, task 0x%p (%s\n", pc, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__

    return (void*)0;
}

extern "C"
void *
__throw_type_match (void *catch_type, void *throw_type, void* obj)
{
#ifdef __U_DEBUG_H__
    uDebugPrt("__throw_type_match( catch_type:0x%p (%s), throw_type:0x%p (%s), obj:0x%p ), task 0x%p (%s)\n",
	      catch_type, catch_type, throw_type, throw_type, obj, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__
    if (strcmp ((const char *)catch_type, (const char *)throw_type) == 0)
	return obj;
    return 0;
}

extern "C"
void
__register_exceptions (exception_table *table)
{
    uRegisterCnt += 1;
    struct exception_table_node *node;
    exception_table *range = table + 1;

    if (range->start == (void*)-1)
	return;

    node = (struct exception_table_node*)
	malloc (sizeof (struct exception_table_node));
    node->table = table;

    /* This look can be optimized away either if the table
       is sorted, or if we pass in extra parameters. */
    node->start = range->start;
    node->end = range->end;
    for (range++ ; range->start != (void*)(-1); range++)
	{
	    if (range->start < node->start)
		node->start = range->start;
	    if (range->end > node->end)
		node->end = range->end;
	}

    node->next = exception_table_list;
    exception_table_list = node;
#ifdef __U_DEBUG_H__
    uDebugPrt("__register_exceptions( table:0x%p ), exception_table_list:0x%p, task 0x%p (%s)\n", table, exception_table_list, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__
}

void
#if #machine(i386)
__unwind_function(void *ptr)
{
#if 0
    printf("__unwind_function (): ptr = %x\n", ptr);
#endif
    asm("movl 8(%esp),%ecx");
    /* Undo current frame */
    asm("movl %ebp,%esp");
    asm("popl %ebp");
    /* like ret, but stay here */
    asm("addl $4,%esp");
  
    /* Now, undo previous frame. */
    /* This is a test routine, as we have to dynamically probe to find out
       what to pop for certain, this is just a guess. */
    asm("leal -16(%ebp),%esp");
    asm("pop %ebx");
    asm("pop %esi");
    asm("pop %edi");
    asm("movl %ebp,%esp");
    asm("popl %ebp");

    asm("movl %ecx,0(%esp)");
    asm("ret");
}
#elif #machine(rs6000)
__unwind_function(void *ptr)
{
#if 0
    printf("__unwind_function (): ptr = %x\n", ptr);
#endif
    asm("mr 31,1");
    asm("l 1,0(1)");
    asm("l 31,-4(1)");
    asm("# br");

    asm("mr 31,1");
    asm("l 1,0(1)");
    /* use 31 as a scratch register to restore the link register. */
    asm("l 31, 8(1);mtlr 31 # l lr,8(1)");
    asm("l 31,-4(1)");
    asm("# br");
    asm("mtctr 3;bctr # b 3");
}
#elif #machine(powerpc)
__unwind_function(void *ptr)
{
#if 0
    printf("__unwind_function (): ptr = %x\n", ptr);
#endif
    asm("mr 31,1");
    asm("lwz 1,0(1)");
    asm("lwz 31,-4(1)");
    asm("# br");

    asm("mr 31,1");
    asm("lwz 1,0(1)");
    /* use 31 as a scratch register to restore the link register. */
    asm("lwz 31, 8(1);mtlr 31 # l lr,8(1)");
    asm("lwz 31,-4(1)");
    asm("# br");
    asm("mtctr 3;bctr # b 3");
}
#elif #machine(vax)
__unwind_function(void *ptr)
{
#if 0
    printf("__unwind_function (): ptr = %x\n", ptr);
#endif
    __label__ return_again;

    /* Replace our frame's return address with the label below.
       During execution, we will first return here instead of to
       caller, then second return takes caller's frame off the stack.
       Two returns matches two actual calls, so is less likely to
       confuse debuggers.  `16' corresponds to RETURN_ADDRESS_OFFSET.  */
    __asm ("movl %0,16(fp)" : : "p" (&& return_again));
    return;

  return_again:
    return;
}
#else
__unwind_function(void *ptr)
{
#if 0
    printf("__unwind_function (): ptr = %x\n", ptr);
#endif
    abort ();
}
#endif /* powerpc */


#endif							// gcc releases >= 2.8


// Local Variables: //
// compile-command: "dmake" //
// End: //
