//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1997
// 
// uDefault.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Thu Mar 20 18:12:31 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jun  6 23:26:50 1998
// Update Count     : 3
// 


#ifndef __U_DEFAULT_H__
#define __U_DEFAULT_H__


// Define the default extension heap amount in units of bytes. When the uC++
// supplied heap reaches the brk address, the brk address is extended by the
// extension amount.

#define __U_DEFAULT_HEAP_EXPANSION__ (64 * 1024)


// Define the default scheduling pre-emption time in milliseconds.  A
// scheduling pre-emption is attempted every default pre-emption milliseconds.
// A pre-emption does not occur if the executing task is not in user code or
// the task is currently in a critical section.  A critical section begins when
// a task acquires a lock and ends when a user releases a lock.

#define __U_DEFAULT_PREEMPTION__ 100


// Define the default spin time in units of checks and context switches. The
// idle task checks the ready queue and context switches this many times before
// the UNIX process executing the idle task goes to sleep.

#define __U_DEFAULT_SPIN__ 500


// Define the default stack size in bytes.  Change the implicit default stack
// size for a task or coroutine created on a particular cluster.

#define __U_DEFAULT_STACK_SIZE__ 32000


extern int uDefaultHeapExpansion();			// default heap expansion size (bytes)
extern int uDefaultStackSize();				// default cluster coroutine/task stack size (bytes)
extern int uMainStackSize();				// default uMain task stack size (bytes)
extern int uDefaultSpin();				// default processor spin time for idle task (context switches)
extern int uDefaultPreemption();			// default processor scheduling pre-emption durations (milliseconds)


#endif __U_DEFAULT_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
