//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
// 
// uDebug.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Sat Dec 18 13:04:26 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Oct 15 17:15:29 1998
// Update Count     : 78
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uDebug.h>
#include <stdio.h>
#include <errno.h>
#include <stdarg.h>
#include <unistd.h>					// prototype: getpid


#if defined( __gizmo__ )
extern "C" int vsprintf(char *, const char *, va_list);
#endif


// This debug print uses its own buffer or a supplied buffer to build the
// output string to ensure that there are no calls to malloc at the file buffer
// level. Therefore, it is safe to call this routine from inside the memory
// management routines because there will be no recursive calls to allocate
// memory.

static char buffer[512];

// SKULLDUGGERY: The debug spin lock has to be available at the same time as
// the heap routines to allow debugging them. Since the initial value of a spin
// lock are zero and static storage is initialized to zero, this works out.

double uDebugLockStorage[(sizeof(uSpinLock) + sizeof(double)) / sizeof(double)] = {0.0};


inline void uDebugAcquire() {
    uDebugLock->uAcquire();
} // uDebugAcquire


inline void uDebugRelease() {
    uDebugLock->uRelease();
} // uDebugRelease


extern "C" void uDebugPrt( const char fmt[], ... ) {
    va_list args;

    va_start( args, fmt );
    uDebugAcquire();
    sprintf( buffer, "(%ld) ", getpid() );		// always print the UNIX pid
    vsprintf( buffer + strlen(buffer), fmt, args );	// and after that the message
    for ( ;; ) {
	int code = write( 2, buffer, strlen(buffer) );
      if ( code != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    uDebugRelease();
    va_end( args );
} // uDebugPrt


// No lock to allow printing after explicitly acquiring the lock.

extern "C" void uDebugPrt2( const char fmt[], ... ) {
    va_list args;

    va_start( args, fmt );
    vsprintf( buffer, fmt, args );
    for ( ;; ) {
	int code = write( 2, buffer, strlen(buffer) );
      if ( code != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    va_end( args );
} // uDebugPrt2


// No lock to allow printing in potential deadlock situations.

extern "C" void uDebugPrtBuf( char buffer[], const char fmt[], ... ) {
    va_list args;

    va_start( args, fmt );
    sprintf( buffer, "(%ld) ", getpid() );		// always print the UNIX pid
    vsprintf( buffer + strlen(buffer), fmt, args );	// and after that the message
    for ( ;; ) {
	int code = write( 2, buffer, strlen(buffer) );
      if ( code != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    va_end( args );
} // uDebugPrt


// Local Variables:
// compile-command: "dmake"
// End:
