//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uContext.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Wed Feb 23 17:32:14 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May 22 14:33:54 1999
// Update Count     : 40
// 


#define __U_KERNEL__
#include <uC++.h>


// Adding or removing from a task's context list requires mutual exclusion
// because a context switch can occur while executing this code, which results
// in the context routine traversing a possibly inconsistent list structure.


uContext::uContext( void *key ) : uKey( key ) {
    // Check the lists of additional contexts for this execution state for a
    // context with the same unique key as the context being added in this
    // call.  If there is a similar context already active for this state, do
    // not add this context again.

    uContext *context;
    for ( uSeqGen<uContext> gen(uThisCoroutine().uAdditionalContexts); gen >> context; ) {
      if ( context->uKey == uKey ) return;
    } // for

    // If no similar context is found, add this context to the list of contexts
    // active for this state.

    uKernelModule::uDisableInterrupts();
    uThisCoroutine().uAdditionalContexts.uAddTail( this );
    uThisCoroutine().uExtras.uIs.uContexts = 1;
    uKernelModule::uEnableInterrupts();
} // uContext::uContext

uContext::uContext() : uKey( this ) {
    uKernelModule::uDisableInterrupts();
    uThisCoroutine().uAdditionalContexts.uAddTail( this );
    uThisCoroutine().uExtras.uIs.uContexts = 1;
    uKernelModule::uEnableInterrupts();
} // uContext::uContext

uContext::~uContext() {
    // If the context is present on a list of contexts, remove it.
    
    if ( this->uListed() ) {
	uKernelModule::uDisableInterrupts();
	uThisCoroutine().uAdditionalContexts.uRemove( this );
	if ( uThisCoroutine().uAdditionalContexts.uEmpty() ) {
	    uThisCoroutine().uExtras.uIs.uContexts = 0;
	} // if
	uKernelModule::uEnableInterrupts();
    } // if
} // uContext::~uContext


// Local Variables: //
// compile-command: "dmake" //
// End: //
